/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util;

import be.atbash.util.ComponentCallback;
import be.atbash.util.PublicAPI;
import be.atbash.util.StringUtils;
import be.atbash.util.exception.AtbashIllegalActionException;
import java.util.ArrayList;
import java.util.List;
import javax.el.ValueExpression;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlOutputLabel;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.context.FacesContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI
public final class ComponentUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentUtils.class);

    private ComponentUtils() {
    }

    public static Object getValue(UIComponent component, FacesContext facesContext) {
        if (component == null) {
            throw new IllegalArgumentException("component parameter is required");
        }
        ValueExpression value = component.getValueExpression("value");
        if (value == null) {
            if (component instanceof ValueHolder) {
                return ((ValueHolder)component).getValue();
            }
            return null;
        }
        return value.getValue(facesContext.getELContext());
    }

    public static boolean isRequired(UIComponent component, FacesContext facesContext) {
        if (component == null) {
            throw new IllegalArgumentException("component parameter is required");
        }
        ValueExpression value = component.getValueExpression("required");
        if (value == null) {
            if (component instanceof EditableValueHolder) {
                return ((EditableValueHolder)component).isRequired();
            }
            return false;
        }
        Object result = value.getValue(facesContext.getELContext());
        if (result != null) {
            return (Boolean)result;
        }
        return false;
    }

    public static String getStyle(UIComponent component, FacesContext facesContext) {
        if (component == null) {
            throw new IllegalArgumentException("component parameter is required");
        }
        ValueExpression value = component.getValueExpression("style");
        if (value == null) {
            if (component instanceof HtmlInputText) {
                return ((HtmlInputText)component).getStyle();
            }
            if (component instanceof HtmlSelectOneMenu) {
                return ((HtmlSelectOneMenu)component).getStyle();
            }
            if (component instanceof HtmlOutputLabel) {
                return ((HtmlOutputLabel)component).getStyle();
            }
            return null;
        }
        return value.getValue(facesContext.getELContext()).toString();
    }

    public static String getStyleClass(UIComponent component, FacesContext facesContext) {
        if (component == null) {
            throw new IllegalArgumentException("component parameter is required");
        }
        ValueExpression value = component.getValueExpression("styleClass");
        if (value == null) {
            if (component instanceof HtmlInputText) {
                return ((HtmlInputText)component).getStyleClass();
            }
            if (component instanceof HtmlSelectOneMenu) {
                return ((HtmlSelectOneMenu)component).getStyleClass();
            }
            if (component instanceof HtmlOutputLabel) {
                return ((HtmlOutputLabel)component).getStyleClass();
            }
            return null;
        }
        return value.getValue(facesContext.getELContext()).toString();
    }

    public static int getMaxLength(UIComponent component, FacesContext facesContext) {
        if (component == null) {
            throw new IllegalArgumentException("component parameter is required");
        }
        ValueExpression value = component.getValueExpression("maxlength");
        if (value == null) {
            if (component instanceof HtmlInputText) {
                return ((HtmlInputText)component).getMaxlength();
            }
            return Integer.MIN_VALUE;
        }
        return Integer.valueOf(value.getValue(facesContext.getELContext()).toString());
    }

    public static <T> T getAttributeValue(UIComponent component, String attributeName, Class<T> resultClass) {
        ValueExpression ve;
        if (component == null) {
            throw new IllegalArgumentException("component parameter is required");
        }
        Object result = null;
        if (component.getAttributes().containsKey(attributeName)) {
            result = Boolean.class.equals(resultClass) ? Boolean.valueOf((String)component.getAttributes().get(attributeName)) : (Object)component.getAttributes().get(attributeName);
        }
        if (result == null && (ve = component.getValueExpression(attributeName)) != null) {
            result = ve.getValue(FacesContext.getCurrentInstance().getELContext());
        }
        return (T)result;
    }

    public static List<UIComponent> findTargets(UIComponent component, String target) {
        if (component == null) {
            throw new IllegalArgumentException("component parameter is required");
        }
        ArrayList<UIComponent> result = new ArrayList<UIComponent>();
        if (StringUtils.isEmpty((String)target)) {
            result.add(component);
        } else {
            String[] targetIds;
            for (String targetId : targetIds = target.split(",")) {
                String id = targetId.trim();
                if (id.contains(" ")) {
                    throw new AtbashIllegalActionException(String.format("(JSF-DEV-01) search id '%s' is invalid", id));
                }
                UIComponent targetComponent = ComponentUtils.lookupComponentInTree(component, id);
                if (targetComponent != null) {
                    result.add(targetComponent);
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Unable to find component with ID %s in view.", targetId));
            }
        }
        return result;
    }

    public static void processTargets(UIComponent component, String target, ComponentCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback parameter is required");
        }
        if (StringUtils.isEmpty((String)target)) {
            callback.handle(component, false);
        } else {
            String[] targets;
            for (String targetId : targets = target.split(",")) {
                String id = targetId.trim();
                if (id.contains(" ")) {
                    throw new AtbashIllegalActionException(String.format("(JSF-DEV-01) search id '%s' is invalid (spaces, ...)", id));
                }
                UIComponent targetComponent = ComponentUtils.lookupComponentInTree(component, id);
                if (targetComponent != null) {
                    callback.handle(targetComponent, false);
                    continue;
                }
                if (ComponentUtils.isInCustomComponent(component)) {
                    callback.handle(component, true);
                    continue;
                }
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Unable to find component with ID %s in view.", targetId));
            }
        }
    }

    private static UIComponent lookupComponentInTree(UIComponent parent, String targetId) {
        UIComponent targetComponent = null;
        if (parent != null) {
            try {
                targetComponent = parent.findComponent(targetId);
            }
            catch (IllegalArgumentException e) {
                throw new AtbashIllegalActionException(String.format("(JSF-DEV-01) search id '%s' references invalid components (intermediates no naming container)", targetId));
            }
            if (targetComponent == null) {
                return ComponentUtils.lookupComponentInTree(parent.getParent(), targetId);
            }
        }
        return targetComponent;
    }

    private static boolean isInCustomComponent(UIComponent uiComponent) {
        boolean result = false;
        if (uiComponent != null && uiComponent.getParent() != null && uiComponent.getParent().getAttributes() != null) {
            result = uiComponent.getParent().getAttributes().containsKey("javax.faces.application.Resource.ComponentResource");
        }
        return result;
    }
}

