/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util;

import be.atbash.util.StringUtils;
import be.atbash.util.exception.AtbashIllegalActionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CDIUtils {
    private static final Map<Class<?>, Method> OPTIONAL_BEAN_INFO = new HashMap();
    private static final Map<Class<?>, Object> OPTIONAL_BEAN = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(CDIUtils.class);

    private CDIUtils() {
    }

    public static <T> List<T> retrieveInstances(Class<T> classType, Annotation ... qualifiers) {
        ArrayList result = new ArrayList();
        for (Object t : CDI.current().select(classType, qualifiers)) {
            result.add(t);
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> T retrieveInstance(Class<T> classType, Annotation ... qualifiers) {
        Instance instance = CDI.current().select(classType, qualifiers);
        if (instance.isUnsatisfied()) {
            throw new UnsatisfiedResolutionException(String.format("No bean found for class %s and qualifiers %s", classType.getName(), qualifiers));
        }
        return (T)instance.get();
    }

    public static <T> T retrieveOptionalInstance(Class<T> classType, Annotation ... qualifiers) {
        Instance instance = CDI.current().select(classType, qualifiers);
        return (T)(instance.isUnsatisfied() ? CDIUtils.getBeanFromProducer(classType) : instance.get());
    }

    public static BeanManager getBeanManager() {
        return CDI.current().getBeanManager();
    }

    public static <T> T retrieveInstanceByName(String beanName, Class<T> targetClass) {
        CreationalContext ctx;
        if (StringUtils.isEmpty((String)beanName)) {
            throw new AtbashIllegalActionException("(CDI-DEV-01) beanName parameter can't be null or empty.");
        }
        BeanManager beanManager = CDIUtils.getBeanManager();
        Iterator iterator = beanManager.getBeans(beanName).iterator();
        if (!iterator.hasNext()) {
            throw new UnsatisfiedResolutionException(String.format("No bean with name '%s' found.", beanName));
        }
        Bean bean = (Bean)iterator.next();
        Object o = beanManager.getReference(bean, Object.class, ctx = beanManager.createCreationalContext((Contextual)bean));
        if (targetClass.isAssignableFrom(o.getClass())) {
            return (T)o;
        }
        throw new UnsatisfiedResolutionException(String.format("No bean with name '%s' and assignable to %s found.", beanName, targetClass.getName()));
    }

    public static void fireEvent(Object event, Annotation ... qualifiers) {
        CDIUtils.getBeanManager().fireEvent(event, qualifiers);
    }

    public static void registerProducerMethod(Method producerMethod) {
        if (producerMethod.getAnnotation(ApplicationScoped.class) == null && producerMethod.getDeclaringClass().getAnnotation(ApplicationScoped.class) == null) {
            throw new AtbashIllegalActionException("(CDI-DEV-53) Only CDI bean Producer methods with scope @ApplicationScoped can be registered");
        }
        OPTIONAL_BEAN_INFO.put(producerMethod.getReturnType(), producerMethod);
    }

    private static <T> T getBeanFromProducer(Class<T> targetClass) {
        Object result = null;
        if (OPTIONAL_BEAN.containsKey(targetClass)) {
            result = OPTIONAL_BEAN.get(targetClass);
        } else if (OPTIONAL_BEAN_INFO.containsKey(targetClass)) {
            Method method = OPTIONAL_BEAN_INFO.get(targetClass);
            Object bean = CDIUtils.retrieveInstance(method.getDeclaringClass(), new Annotation[0]);
            try {
                result = method.invoke(bean, new Object[0]);
                OPTIONAL_BEAN.put(targetClass, result);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Exception occured during invocation of producer method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error("Exception occured during invocation of producer method", (Throwable)e);
            }
        }
        return (T)result;
    }
}

