/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.util;

import be.atbash.util.FakeBean;
import be.atbash.util.FakeCDI;
import be.atbash.util.PublicAPI;
import be.atbash.util.exception.AtbashIllegalActionException;
import be.atbash.util.literal.AnyLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@PublicAPI
public class BeanManagerFake {
    private BeanManager beanManagerMock = (BeanManager)Mockito.mock(BeanManager.class);
    private Map<Class<?>, List<Object>> registeredObjects = new HashMap();
    private Map<String, Object> registeredBeans = new HashMap<String, Object>();

    public BeanManagerFake() {
        new FakeCDI(this.beanManagerMock, this.registeredObjects);
    }

    public void registerBean(Object instance, Class<?> ... typesToRegister) {
        if (typesToRegister == null || typesToRegister.length == 0) {
            throw new AtbashIllegalActionException("(CDI-DEV-51) typesToRegister is required to have at least 1 Class type.");
        }
        if (instance == null) {
            throw new AtbashIllegalActionException("(CDI-DEV-52) Can't register a null instance");
        }
        for (Class<?> typeToRegister : typesToRegister) {
            List<Object> objects = this.registeredObjects.get(typeToRegister);
            if (objects == null) {
                objects = new ArrayList<Object>();
                this.registeredObjects.put(typeToRegister, objects);
            }
            objects.add(instance);
        }
    }

    public void registerBean(String beanName, Object instance) {
        this.registeredBeans.put(beanName, instance);
    }

    public void endRegistration() {
        HashSet beans;
        for (Map.Entry<Class<?>, List<Object>> entry : this.registeredObjects.entrySet()) {
            beans = new HashSet();
            for (Object object : entry.getValue()) {
                beans.add(new FakeBean(object));
            }
            Mockito.when((Object)this.beanManagerMock.getBeans((Type)entry.getKey(), new Annotation[]{new AnyLiteral()})).thenReturn(beans);
            for (Bean bean : beans) {
                Mockito.when((Object)this.beanManagerMock.getReference(bean, (Type)entry.getKey(), null)).thenReturn(((FakeBean)bean).getRealBean());
            }
        }
        ((BeanManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                Set arg = (Set)invocationOnMock.getArguments()[0];
                return arg.iterator().next();
            }
        }).when((Object)this.beanManagerMock)).resolve(Matchers.anySet());
        for (Map.Entry<Object, Object> entry : this.registeredBeans.entrySet()) {
            beans = new HashSet();
            FakeBean bean = new FakeBean(entry.getValue());
            beans.add(bean);
            Mockito.when((Object)this.beanManagerMock.getBeans((String)entry.getKey())).thenReturn(beans);
            Mockito.when((Object)this.beanManagerMock.getReference(bean, Object.class, null)).thenReturn(entry.getValue());
        }
    }

    public void deregistration() {
        Mockito.reset((Object[])new BeanManager[]{this.beanManagerMock});
        this.beanManagerMock = null;
    }
}

