/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.mp.rest_client.spec;

import be.atbash.config.ConfigOptionalValue;
import be.atbash.mp.rest_client.LocalProviderInfo;
import be.atbash.mp.rest_client.RestClientInvoker;
import be.atbash.mp.rest_client.exception.DefaultResponseExceptionMapper;
import be.atbash.mp.rest_client.proxy.BasicProxyInvocationHandler;
import be.atbash.mp.rest_client.proxy.BasicRestClientProxyFactory;
import be.atbash.mp.rest_client.proxy.RestClientProxyFactory;
import be.atbash.util.CDIUtils;
import be.atbash.util.reflection.CDICheck;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.spi.BeanManager;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.ext.ParamConverterProvider;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxy;
import org.apache.deltaspike.proxy.spi.invocation.DeltaSpikeProxyInvocationHandler;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientDefinitionException;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BuilderImpl
implements RestClientBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuilderImpl.class);
    private static final String DEFAULT_MAPPER_PROP = "microprofile.rest.client.disable.default.mapper";
    private static final String URI_PARAM_NAME_REGEX = "\\w[\\w\\.-]*";
    private static final String URI_PARAM_REGEX_REGEX = "[^{}][^{}]*";
    private static final String URI_PARAM_REGEX = "\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))?\\}";
    private static final Pattern URI_PARAM_PATTERN = Pattern.compile("\\{\\s*(\\w[\\w\\.-]*)\\s*(:\\s*([^{}][^{}]*))?\\}");
    private static final char openCurlyReplacement = '\u0006';
    private static final char closeCurlyReplacement = '\u0007';
    private ClientBuilder clientBuilder;
    private DeltaSpikeProxyInvocationHandler deltaSpikeProxyInvocationHandler;
    private BeanManager beanManager;
    private String baseURI;
    private Set<LocalProviderInfo> localProviderInstances = new HashSet<LocalProviderInfo>();

    BuilderImpl() {
        this.clientBuilder = ClientBuilder.newBuilder();
    }

    public RestClientBuilder baseUrl(URL url) {
        try {
            this.baseURI = url.toURI().toString().replaceFirst("/*$", "");
            return this;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public <T> T build(Class<T> targetClass) throws IllegalStateException, RestClientDefinitionException {
        Method[] delegateMethods;
        Class proxyClass;
        this.verifyInterface(targetClass);
        if (CDICheck.withinContainer()) {
            RestClientProxyFactory proxyFactory = RestClientProxyFactory.getInstance();
            this.beanManager = CDIUtils.getBeanManager();
            proxyClass = proxyFactory.getProxyClass(this.beanManager, targetClass);
            delegateMethods = proxyFactory.getDelegateMethods(targetClass);
        } else {
            BasicRestClientProxyFactory proxyFactory = BasicRestClientProxyFactory.getInstance();
            proxyClass = proxyFactory.getProxyClass(targetClass);
            delegateMethods = proxyFactory.getDelegateMethods(targetClass);
        }
        return this.create(targetClass, proxyClass, delegateMethods);
    }

    private <T> T create(Class<T> targetClass, Class<T> proxyClass, Method[] delegateMethods) {
        try {
            this.lazyInit();
            T instance = proxyClass.newInstance();
            DeltaSpikeProxy deltaSpikeProxy = (DeltaSpikeProxy)instance;
            deltaSpikeProxy.setInvocationHandler(this.deltaSpikeProxyInvocationHandler);
            deltaSpikeProxy.setDelegateMethods(delegateMethods);
            if (this.baseURI == null) {
                this.baseUrl((URL)ConfigProvider.getConfig().getValue(targetClass.getName() + "/mp-rest/url", URL.class));
            }
            RestClientInvoker restClientInvoker = new RestClientInvoker(this.clientBuilder.build(), this.baseURI, this.defineLocalProviderInstances());
            deltaSpikeProxy.setDelegateInvocationHandler((InvocationHandler)restClientInvoker);
            return instance;
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
            return null;
        }
    }

    private List<LocalProviderInfo> defineLocalProviderInstances() {
        if (!this.isMapperDisabled()) {
            this.register(DefaultResponseExceptionMapper.class);
        }
        ArrayList<LocalProviderInfo> result = new ArrayList<LocalProviderInfo>(this.localProviderInstances);
        Collections.sort(result, new Comparator<LocalProviderInfo>(){

            @Override
            public int compare(LocalProviderInfo lpi1, LocalProviderInfo lpi2) {
                Integer i1 = lpi1.getPriority();
                Integer i2 = lpi2.getPriority();
                return i1.compareTo(i2);
            }
        });
        return result;
    }

    private boolean isMapperDisabled() {
        boolean disabled = false;
        Boolean defaultMapperProp = (Boolean)ConfigOptionalValue.getValue((String)DEFAULT_MAPPER_PROP, Boolean.class);
        if (defaultMapperProp != null && defaultMapperProp.booleanValue()) {
            disabled = true;
        } else if (defaultMapperProp == null) {
            // empty if block
        }
        return disabled;
    }

    private void lazyInit() {
        if (this.deltaSpikeProxyInvocationHandler == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.deltaSpikeProxyInvocationHandler == null) {
            this.deltaSpikeProxyInvocationHandler = CDICheck.withinContainer() ? (DeltaSpikeProxyInvocationHandler)BeanProvider.getContextualReference((BeanManager)this.beanManager, DeltaSpikeProxyInvocationHandler.class, (boolean)false, (Annotation[])new Annotation[0]) : new BasicProxyInvocationHandler();
        }
    }

    private <T> void verifyInterface(Class<T> typeDef) {
        Method[] methods;
        for (Method method : methods = typeDef.getMethods()) {
            boolean hasHttpMethod = false;
            for (Annotation annotation : method.getAnnotations()) {
                boolean isHttpMethod;
                boolean bl = isHttpMethod = annotation.annotationType().getAnnotation(HttpMethod.class) != null;
                if (!hasHttpMethod && isHttpMethod) {
                    hasHttpMethod = true;
                    continue;
                }
                if (!hasHttpMethod || !isHttpMethod) continue;
                throw new RestClientDefinitionException("Ambiguous @Httpmethod defintion on type " + typeDef);
            }
        }
        Path classPathAnno = typeDef.getAnnotation(Path.class);
        HashSet<String> classLevelVariables = new HashSet<String>();
        if (classPathAnno != null) {
            classLevelVariables.addAll(this.getPathParamList(classPathAnno.value()));
        }
        for (Method method : methods) {
            Path methodPathAnno = method.getAnnotation(Path.class);
            if (methodPathAnno == null) continue;
            HashSet<String> allVariables = new HashSet<String>(classLevelVariables);
            allVariables.addAll(this.getPathParamList(methodPathAnno.value()));
            HashSet<String> parameterNames = new HashSet<String>();
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = annotationArray[i]) {
                    if (!PathParam.class.equals(annotation.annotationType())) continue;
                    parameterNames.add(((PathParam)annotation).value());
                }
            }
            if (allVariables.size() != parameterNames.size()) {
                throw new RestClientDefinitionException(String.format("Parameters and variables don't match on %s::%s", typeDef, method.getName()));
            }
            parameterNames.removeAll(allVariables);
            if (parameterNames.isEmpty()) continue;
            throw new RestClientDefinitionException(String.format("Parameter names don't match variable names on %s::%s", typeDef, method.getName()));
        }
    }

    private List<String> getPathParamList(String string) {
        ArrayList<String> params = new ArrayList<String>();
        Matcher matcher = URI_PARAM_PATTERN.matcher(this.replaceEnclosedCurlyBraces(string));
        while (matcher.find()) {
            String param = matcher.group(1);
            params.add(param);
        }
        return params;
    }

    private CharSequence replaceEnclosedCurlyBraces(String str) {
        char[] chars = str.toCharArray();
        int open = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '{') {
                if (open != 0) {
                    chars[i] = 6;
                }
                ++open;
                continue;
            }
            if (chars[i] != '}' || --open == 0) continue;
            chars[i] = 7;
        }
        return new String(chars);
    }

    public Configuration getConfiguration() {
        return this.clientBuilder.getConfiguration();
    }

    public RestClientBuilder property(String name, Object value) {
        this.clientBuilder.property(name, value);
        return this;
    }

    private static Object newInstanceOf(Class clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to register " + clazz, t);
        }
    }

    public RestClientBuilder register(Class<?> aClass) {
        this.register(BuilderImpl.newInstanceOf(aClass));
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, int i) {
        this.register(BuilderImpl.newInstanceOf(aClass), i);
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, Class<?>[] classes) {
        this.register(BuilderImpl.newInstanceOf(aClass), classes);
        return this;
    }

    public RestClientBuilder register(Class<?> aClass, Map<Class<?>, Integer> map) {
        this.register(BuilderImpl.newInstanceOf(aClass), map);
        return this;
    }

    public RestClientBuilder register(Object o) {
        if (o instanceof ResponseExceptionMapper) {
            ResponseExceptionMapper mapper = (ResponseExceptionMapper)o;
            this.register((Object)mapper, mapper.getPriority());
        } else if (o instanceof ParamConverterProvider) {
            this.register(o, 5000);
        } else {
            this.clientBuilder.register(o);
        }
        return this;
    }

    public RestClientBuilder register(Object o, int priority) {
        if (o instanceof ResponseExceptionMapper) {
            ResponseExceptionMapper mapper = (ResponseExceptionMapper)o;
            this.registerLocalProviderInstance(mapper, priority);
        } else if (o instanceof ParamConverterProvider) {
            ParamConverterProvider converter = (ParamConverterProvider)o;
            this.registerLocalProviderInstance(converter, priority);
        } else {
            this.clientBuilder.register(o, priority);
        }
        return this;
    }

    public RestClientBuilder register(Object o, Class<?>[] classes) {
        for (Class<ResponseExceptionMapper> clazz : classes) {
            if (!clazz.isAssignableFrom(ResponseExceptionMapper.class)) continue;
            this.register(o);
        }
        this.clientBuilder.register(o, (Class[])classes);
        return this;
    }

    public RestClientBuilder register(Object component, Map<Class<?>, Integer> contracts) {
        return this;
    }

    private void registerLocalProviderInstance(Object provider, int priority) {
        for (LocalProviderInfo registered : this.localProviderInstances) {
            if (!registered.getLocalProvider().equals(provider)) continue;
            LOGGER.warn(String.format("Provider already registered %s", provider.getClass().getName()));
            return;
        }
        this.localProviderInstances.add(new LocalProviderInfo(provider, priority));
    }
}

