/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.mp.rest_client.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ReflectionUtils;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxyClassGenerator;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxyClassGeneratorHolder;

public class BasicRestClientProxyFactory {
    private static final BasicRestClientProxyFactory INSTANCE = new BasicRestClientProxyFactory();
    private static final String SUPER_ACCESSOR_METHOD_SUFFIX = "$super";

    public static BasicRestClientProxyFactory getInstance() {
        return INSTANCE;
    }

    private String getProxyClassSuffix() {
        return "$$AtbashRestClientProxy";
    }

    private ArrayList<Method> getDelegateMethods(Class<?> targetClass, ArrayList<Method> allMethods) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (!Modifier.isAbstract(method.getModifiers())) continue;
            methods.add(method);
        }
        return methods;
    }

    private <T> Class<T> resolveAlreadyDefinedProxyClass(Class<T> targetClass) {
        return ClassUtils.tryToLoadClassForName((String)this.constructProxyClassName(targetClass), targetClass, (ClassLoader)targetClass.getClassLoader());
    }

    public <T> Class<T> getProxyClass(Class<T> targetClass) {
        Class<T> proxyClass = this.resolveAlreadyDefinedProxyClass(targetClass);
        if (proxyClass == null) {
            proxyClass = this.createProxyClass(targetClass.getClassLoader(), targetClass);
        }
        return proxyClass;
    }

    private synchronized <T> Class<T> createProxyClass(ClassLoader classLoader, Class<T> targetClass) {
        Class proxyClass = this.resolveAlreadyDefinedProxyClass(targetClass);
        if (proxyClass == null) {
            ArrayList<Method> allMethods = this.collectAllMethods(targetClass);
            ArrayList<Method> interceptMethods = this.filterInterceptMethods(targetClass, allMethods);
            Method[] delegateMethods = this.getDelegateMethods(targetClass);
            if (interceptMethods != null && !interceptMethods.isEmpty()) {
                for (Method method : interceptMethods) {
                }
            }
            DeltaSpikeProxyClassGenerator proxyClassGenerator = DeltaSpikeProxyClassGeneratorHolder.lookup();
            Class[] additionalInterfacesToImplement = this.getAdditionalInterfacesToImplement(targetClass);
            proxyClass = proxyClassGenerator.generateProxyClass(classLoader, targetClass, this.getProxyClassSuffix(), SUPER_ACCESSOR_METHOD_SUFFIX, additionalInterfacesToImplement, delegateMethods, interceptMethods == null ? new Method[]{} : interceptMethods.toArray(new Method[interceptMethods.size()]));
        }
        return proxyClass;
    }

    private String constructProxyClassName(Class<?> clazz) {
        return clazz.getName() + this.getProxyClassSuffix();
    }

    private static String constructSuperAccessorMethodName(Method method) {
        return method.getName() + SUPER_ACCESSOR_METHOD_SUFFIX;
    }

    public static Method getSuperAccessorMethod(Object proxy, Method method) throws NoSuchMethodException {
        return proxy.getClass().getMethod(BasicRestClientProxyFactory.constructSuperAccessorMethodName(method), method.getParameterTypes());
    }

    public boolean isProxyClass(Class<?> clazz) {
        return clazz.getName().endsWith(this.getProxyClassSuffix());
    }

    private boolean ignoreMethod(Method method, List<Method> methods) {
        if (method.isBridge()) {
            return true;
        }
        if ("finalize".equals(method.getName())) {
            return true;
        }
        if (methods.contains(method)) {
            return true;
        }
        for (Method currentMethod : methods) {
            if (!ReflectionUtils.hasSameSignature((Method)currentMethod, (Method)method)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Method> collectAllMethods(Class<?> clazz) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            if (this.ignoreMethod(method, methods)) continue;
            methods.add(method);
        }
        for (Method method : clazz.getMethods()) {
            if (this.ignoreMethod(method, methods)) continue;
            methods.add(method);
        }
        for (Class<?> currentSuperClass = clazz.getSuperclass(); currentSuperClass != null; currentSuperClass = currentSuperClass.getSuperclass()) {
            if (!Modifier.isAbstract(currentSuperClass.getModifiers())) continue;
            for (Method method : currentSuperClass.getDeclaredMethods()) {
                if (this.ignoreMethod(method, methods)) continue;
                methods.add(method);
            }
            for (Method method : currentSuperClass.getMethods()) {
                if (this.ignoreMethod(method, methods)) continue;
                methods.add(method);
            }
        }
        for (Class<?> currentClass = clazz; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Iterator<Method> methodIterator = methods.iterator();
            while (methodIterator.hasNext()) {
                Method method = methodIterator.next();
                if (!Modifier.isAbstract(method.getModifiers())) continue;
                try {
                    Method foundMethod = currentClass.getMethod(method.getName(), method.getParameterTypes());
                    if (foundMethod == null || Modifier.isAbstract(foundMethod.getModifiers())) continue;
                    methodIterator.remove();
                }
                catch (Exception exception) {}
            }
        }
        return methods;
    }

    private ArrayList<Method> filterInterceptMethods(Class<?> targetClass, ArrayList<Method> allMethods) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : allMethods) {
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isFinal(method.getModifiers()) || Modifier.isAbstract(method.getModifiers())) continue;
            methods.add(method);
        }
        return methods;
    }

    private Class<?>[] getAdditionalInterfacesToImplement(Class<?> targetClass) {
        return null;
    }

    public Method[] getDelegateMethods(Class<?> targetClass) {
        ArrayList<Method> allMethods = this.collectAllMethods(targetClass);
        ArrayList<Method> delegateMethods = this.getDelegateMethods(targetClass, allMethods);
        return delegateMethods == null ? new Method[]{} : delegateMethods.toArray(new Method[delegateMethods.size()]);
    }
}

