/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.mp.rest_client;

import be.atbash.mp.rest_client.LocalProviderInfo;
import be.atbash.mp.rest_client.ParameterInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

public class RestClientInvoker
implements InvocationHandler {
    private Client client;
    private String baseURI;
    private List<LocalProviderInfo> localProviderInstances;

    public RestClientInvoker(Client client, String baseURI, List<LocalProviderInfo> localProviderInstances) {
        this.client = client;
        this.baseURI = baseURI;
        this.localProviderInstances = localProviderInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        StringBuilder serverURL = this.determineEndpointURL(method);
        String httpMethod = this.determineMethod(method);
        if (httpMethod == null) {
            throw new RuntimeException(String.format("Unknown http method at %s", method));
        }
        ParameterInfo parameterInfo = this.determineParameterInfo(method, args);
        UriBuilder uriBuilder = UriBuilder.fromUri((String)serverURL.toString());
        for (Map.Entry<String, Object> entry : parameterInfo.getQueryParameterValues().entrySet()) {
            uriBuilder.queryParam(entry.getKey(), new Object[]{entry.getValue()});
        }
        String url = uriBuilder.buildFromMap(parameterInfo.getPathParameterValues()).toString();
        Invocation.Builder request = this.client.target(url).request().headers(parameterInfo.getHeaderValues());
        Invocation invocation = parameterInfo.getPayload() != null ? request.build(httpMethod, Entity.entity((Object)parameterInfo.getPayload(), (String)"application/json")) : request.build(httpMethod);
        Object result = null;
        try (Response response = invocation.invoke();){
            this.handleExceptionMapping(response, Arrays.asList(method.getExceptionTypes()));
            if (!Void.TYPE.equals(method.getReturnType())) {
                result = response.readEntity(method.getReturnType());
            }
        }
        return result;
    }

    private void handleExceptionMapping(Response response, List<Class<?>> exceptionTypes) throws Throwable {
        int status = response.getStatus();
        MultivaluedMap headers = response.getHeaders();
        for (LocalProviderInfo localProviderInfo : this.localProviderInstances) {
            Throwable throwable;
            ResponseExceptionMapper mapper;
            if (!(localProviderInfo.getLocalProvider() instanceof ResponseExceptionMapper) || !(mapper = (ResponseExceptionMapper)localProviderInfo.getLocalProvider()).handles(status, headers) || (throwable = mapper.toThrowable(response)) == null) continue;
            this.throwExceptionIfAppropriate(throwable, exceptionTypes);
        }
    }

    private void throwExceptionIfAppropriate(Throwable throwable, List<Class<?>> exceptionTypes) throws Throwable {
        if (throwable instanceof RuntimeException) {
            throw throwable;
        }
        if (throwable instanceof Error) {
            throw throwable;
        }
        for (Class<?> exceptionType : exceptionTypes) {
            if (!exceptionType.isAssignableFrom(throwable.getClass())) continue;
            throw throwable;
        }
    }

    private String determineMethod(Method method) {
        if (method.getAnnotation(GET.class) != null) {
            return "GET";
        }
        if (method.getAnnotation(PUT.class) != null) {
            return "PUT";
        }
        if (method.getAnnotation(POST.class) != null) {
            return "POST";
        }
        if (method.getAnnotation(DELETE.class) != null) {
            return "DELETE";
        }
        return null;
    }

    private ParameterInfo determineParameterInfo(Method method, Object[] args) {
        ParameterInfo result = new ParameterInfo();
        int paramIndex = 0;
        for (Annotation[] annotations : method.getParameterAnnotations()) {
            boolean jaxrsAnnotationFound = false;
            for (Annotation annotation : annotations) {
                if (PathParam.class.equals(annotation.annotationType())) {
                    result.addPathParameterValue(((PathParam)annotation).value(), args[paramIndex]);
                    jaxrsAnnotationFound = true;
                }
                if (QueryParam.class.equals(annotation.annotationType())) {
                    result.addQueryParameterValue(((QueryParam)annotation).value(), args[paramIndex]);
                    jaxrsAnnotationFound = true;
                }
                if (!HeaderParam.class.equals(annotation.annotationType())) continue;
                result.addHeaderValue(((HeaderParam)annotation).value(), args[paramIndex]);
                jaxrsAnnotationFound = true;
            }
            if (!jaxrsAnnotationFound) {
                result.setPayload(args[paramIndex]);
            }
            ++paramIndex;
        }
        return result;
    }

    private StringBuilder determineEndpointURL(Method method) {
        Path methodPathAnnotation;
        StringBuilder serverURL = new StringBuilder();
        serverURL.append(this.baseURI);
        Path classPathAnnotation = method.getDeclaringClass().getAnnotation(Path.class);
        if (classPathAnnotation != null) {
            String value = classPathAnnotation.value();
            if (!value.startsWith("/")) {
                serverURL.append('/');
            }
            serverURL.append(value);
        }
        if ((methodPathAnnotation = method.getAnnotation(Path.class)) != null) {
            String value = methodPathAnnotation.value();
            if (!value.startsWith("/")) {
                serverURL.append('/');
            }
            serverURL.append(value);
        }
        return serverURL;
    }
}

