/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.mp.rest_client.cdi;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import org.eclipse.microprofile.rest.client.AbstractRestClientBuilder;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.annotation.RegisterProvider;
import org.eclipse.microprofile.rest.client.annotation.RegisterProviders;

@Dependent
public class InjectableRestClient
implements InvocationHandler {
    private Map<Class, Object> restClientInvokerCache = new HashMap<Class, Object>();

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object restClientInvoker = this.restClientInvokerCache.get(method.getDeclaringClass());
        if (restClientInvoker == null) {
            RestClientBuilder restClientBuilder = AbstractRestClientBuilder.newBuilder();
            this.registerProviders(restClientBuilder, method);
            restClientInvoker = restClientBuilder.build(method.getDeclaringClass());
            this.restClientInvokerCache.put(method.getDeclaringClass(), restClientInvoker);
        }
        return method.invoke(restClientInvoker, args);
    }

    private void registerProviders(RestClientBuilder restClientBuilder, Method method) {
        RegisterProviders registerProviders;
        RegisterProvider provider = method.getDeclaringClass().getAnnotation(RegisterProvider.class);
        if (provider != null) {
            this.registerSingleProvider(restClientBuilder, provider);
        }
        if ((registerProviders = method.getDeclaringClass().getAnnotation(RegisterProviders.class)) != null) {
            for (RegisterProvider registerProvider : registerProviders.value()) {
                this.registerSingleProvider(restClientBuilder, registerProvider);
            }
        }
    }

    private void registerSingleProvider(RestClientBuilder restClientBuilder, RegisterProvider provider) {
        Priority priorityAnnotation;
        Class providerClass = provider.value();
        int priority = provider.priority();
        if (priority == -1 && (priorityAnnotation = providerClass.getAnnotation(Priority.class)) != null) {
            priority = priorityAnnotation.value();
        }
        if (priority == -1) {
            restClientBuilder.register(providerClass);
        } else {
            restClientBuilder.register(providerClass, priority);
        }
    }
}

