/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.keys.diffiehellman.json;

import be.atbash.json.writer.CustomBeanJSONEncoder;
import be.atbash.keys.diffiehellman.BobPublicData;
import be.atbash.util.base64.Base64Codec;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;

public class BobPublicDataJSONEncoder
extends CustomBeanJSONEncoder<BobPublicData> {
    public BobPublicDataJSONEncoder() {
        super(BobPublicData.class);
    }

    protected void setCustomValue(BobPublicData current, String key, Object value) {
        if ("kid".equals(key)) {
            current.addProperty(key, value);
        }
        if ("publicKey".equals(key)) {
            this.handlePublicKey(current, value.toString());
        }
    }

    private void handlePublicKey(BobPublicData current, String value) {
        try {
            KeyFactory kf = KeyFactory.getInstance("DH");
            X509EncodedKeySpec x509Spec = new X509EncodedKeySpec(Base64Codec.decode((String)value));
            PublicKey pk = kf.generatePublic(x509Spec);
            current.addProperty("publicKey", pk);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }
}

