/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.keys.diffiehellman.json;

import be.atbash.json.writer.CustomBeanJSONEncoder;
import be.atbash.keys.diffiehellman.AlicePublicData;
import be.atbash.util.base64.Base64Codec;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.List;

public class AlicePublicDataJSONEncoder
extends CustomBeanJSONEncoder<AlicePublicData> {
    private static final List<String> PASSTHROUGH_KEYS = Arrays.asList("p", "g", "l", "kid");

    public AlicePublicDataJSONEncoder() {
        super(AlicePublicData.class);
    }

    protected void setCustomValue(AlicePublicData current, String key, Object value) {
        if (PASSTHROUGH_KEYS.contains(key)) {
            current.addProperty(key, value);
        }
        if ("publicKey".equals(key)) {
            this.handlePublicKey(current, value.toString());
        }
    }

    private void handlePublicKey(AlicePublicData current, String value) {
        try {
            KeyFactory kf = KeyFactory.getInstance("DH");
            X509EncodedKeySpec x509Spec = new X509EncodedKeySpec(Base64Codec.decode((String)value));
            PublicKey pk = kf.generatePublic(x509Spec);
            current.addProperty("publicKey", pk);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }
}

