/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.keys.diffiehellman;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.KeyManager;
import be.atbash.ee.security.octopus.keys.generator.DHGenerationParameters;
import be.atbash.ee.security.octopus.keys.generator.GenerationParameters;
import be.atbash.ee.security.octopus.keys.generator.KeyGenerator;
import be.atbash.ee.security.octopus.keys.selector.SelectorCriteria;
import be.atbash.ee.security.octopus.keys.selector.filter.IdKeyFilter;
import be.atbash.ee.security.octopus.keys.selector.filter.KeyFilter;
import be.atbash.util.exception.AtbashIllegalActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.crypto.spec.DHParameterSpec;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class DHKeyManager
implements KeyManager {
    private static DHKeyManager INSTANCE;
    private KeyGenerator keyGenerator;
    private Map<String, List<AtbashKey>> keys;

    private void init() {
        this.keys = new HashMap<String, List<AtbashKey>>();
        this.keyGenerator = new KeyGenerator();
    }

    public List<AtbashKey> retrieveKeys(SelectorCriteria selectorCriteria) {
        if (selectorCriteria == null) {
            throw new AtbashIllegalActionException("Parameter selectorCriteria can't be null");
        }
        List filters = selectorCriteria.asKeyFilters();
        List<Object> result = new ArrayList<AtbashKey>();
        for (Map.Entry<String, List<AtbashKey>> entry : this.keys.entrySet()) {
            result.addAll((Collection<AtbashKey>)entry.getValue());
        }
        for (KeyFilter filter : filters) {
            result = filter.filter(result);
        }
        return result;
    }

    public void createKeyPair(String tenantId, String kid) {
        this.createKeyPair(tenantId, kid, null);
    }

    public void createKeyPair(String tenantId, String kid, DHParameterSpec parameterSpec) {
        DHGenerationParameters.DHGenerationParametersBuilder parameterBuilder = (DHGenerationParameters.DHGenerationParametersBuilder)new DHGenerationParameters.DHGenerationParametersBuilder().withKeyId(kid);
        if (parameterSpec == null) {
            parameterBuilder.withKeySize(1024);
        } else {
            parameterBuilder.withDHParamaterSpec(parameterSpec);
        }
        List<AtbashKey> atbashKeys = this.getKeysForTenantId(tenantId);
        atbashKeys.addAll(this.keyGenerator.generateKeys((GenerationParameters)parameterBuilder.build()));
    }

    public void storePublicKey(String tenantId, AtbashKey publicKey) {
        List<AtbashKey> atbashKeys = this.getKeysForTenantId(tenantId);
        boolean found = false;
        for (AtbashKey atbashKey : atbashKeys) {
            if (!publicKey.getKeyId().equals(atbashKey.getKeyId())) continue;
            found = true;
        }
        if (!found) {
            atbashKeys.add(publicKey);
        }
    }

    private List<AtbashKey> getKeysForTenantId(String tenantId) {
        List<AtbashKey> atbashKeys = this.keys.get(tenantId);
        if (atbashKeys == null) {
            atbashKeys = new ArrayList<AtbashKey>();
            this.keys.put(tenantId, atbashKeys);
        }
        return atbashKeys;
    }

    public void removeKeys(String tenantId, SelectorCriteria selectorCriteria) {
        IdKeyFilter keyFilter = this.getKeyFilter(selectorCriteria.asKeyFilters());
        Iterator<AtbashKey> iterator = this.keys.get(tenantId).iterator();
        while (iterator.hasNext()) {
            AtbashKey key = iterator.next();
            if (!key.getKeyId().endsWith(keyFilter.getKeyId())) continue;
            iterator.remove();
        }
        if (this.keys.get(tenantId).isEmpty()) {
            this.keys.remove(tenantId);
        }
    }

    private IdKeyFilter getKeyFilter(List<KeyFilter> keyFilters) {
        IdKeyFilter result = null;
        for (KeyFilter keyFilter : keyFilters) {
            if (!(keyFilter instanceof IdKeyFilter)) continue;
            result = (IdKeyFilter)keyFilter;
        }
        return result;
    }

    public static synchronized DHKeyManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DHKeyManager();
            INSTANCE.init();
        }
        return INSTANCE;
    }
}

