/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.keys.diffiehellman;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import be.atbash.ee.security.octopus.keys.selector.SelectorCriteria;
import be.atbash.keys.diffiehellman.AlicePublicData;
import be.atbash.keys.diffiehellman.BobPublicData;
import be.atbash.keys.diffiehellman.DHKeyManager;
import be.atbash.keys.diffiehellman.DHKeySelector;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.PostConstruct;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class DHKeyExchangeManager {
    private static DHKeyExchangeManager INSTANCE;
    private DHKeyManager dhKeyManager;
    private DHKeySelector dhKeySelector;
    private Map<String, List<String>> exchangeIdsForTenant;

    @PostConstruct
    public void init() {
        this.dhKeyManager = DHKeyManager.getInstance();
        this.dhKeySelector = new DHKeySelector();
        this.exchangeIdsForTenant = new HashMap<String, List<String>>();
    }

    public AlicePublicData startExchange(String tenantId) {
        String exchangeID = UUID.randomUUID().toString();
        String kid = "alice-" + exchangeID;
        this.dhKeyManager.createKeyPair(tenantId, kid);
        AtbashKey atbashKey = this.getPublicKey(kid);
        AlicePublicData result = new AlicePublicData();
        result.setTenantId(tenantId);
        result.setPublicKey(atbashKey);
        result.setDhParameterSpec(((DHPublicKey)atbashKey.getKey()).getParams());
        return result;
    }

    private void storeExchangeId(String tenantId, String exchangeId) {
        List<String> ids = this.exchangeIdsForTenant.get(tenantId);
        if (ids == null) {
            ids = new ArrayList<String>();
            this.exchangeIdsForTenant.put(tenantId, ids);
        }
        ids.add(exchangeId);
    }

    private AtbashKey getPublicKey(String kid) {
        SelectorCriteria criteria = SelectorCriteria.newBuilder().withId(kid).withAsymmetricPart(AsymmetricPart.PUBLIC).build();
        return this.dhKeySelector.selectAtbashKey(criteria);
    }

    public BobPublicData acknowledgeExchange(AlicePublicData publicData) {
        this.dhKeyManager.storePublicKey(publicData.getTenantId(), publicData.getPublicKey());
        this.storeExchangeId(publicData.getTenantId(), publicData.getPublicKey().getKeyId());
        String kid = publicData.getPublicKey().getKeyId().replaceAll("alice-", "bob-");
        this.dhKeyManager.createKeyPair(publicData.getTenantId(), kid);
        AtbashKey atbashKey = this.getPublicKey(kid);
        BobPublicData result = new BobPublicData();
        result.setTenantId(publicData.getTenantId());
        result.setPublicKey(atbashKey);
        return result;
    }

    public SecretKey defineSecretKey(AtbashKey publicKey) {
        String privateKeyId = this.definePrivateKeyId(publicKey.getKeyId());
        AtbashKey privateKey = this.getPrivateKey(privateKeyId);
        try {
            KeyAgreement ka = KeyAgreement.getInstance("DH");
            ka.init(privateKey.getKey());
            ka.doPhase(publicKey.getKey(), true);
            byte[] secret = ka.generateSecret();
            char[] chars = new char[secret.length];
            for (int i = 0; i < secret.length; ++i) {
                chars[i] = (char)secret[i];
            }
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            byte[] secretBytes = keyFactory.generateSecret(new PBEKeySpec(chars, secret, 1014, 128)).getEncoded();
            return new SecretKeySpec(secretBytes, "AES");
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }

    public SecretKey defineSecretKey(String exchangeId) {
        AtbashKey publicKey = this.retrieveKeyPublicKey(exchangeId);
        return this.defineSecretKey(publicKey);
    }

    private AtbashKey retrieveKeyPublicKey(String exchangeId) {
        SelectorCriteria criteria = SelectorCriteria.newBuilder().withId(exchangeId).withAsymmetricPart(AsymmetricPart.PUBLIC).build();
        return this.dhKeySelector.selectAtbashKey(criteria);
    }

    private AtbashKey getPrivateKey(String kid) {
        SelectorCriteria criteria = SelectorCriteria.newBuilder().withId(kid).withAsymmetricPart(AsymmetricPart.PRIVATE).build();
        return this.dhKeySelector.selectAtbashKey(criteria);
    }

    private String definePrivateKeyId(String keyId) {
        if (keyId.startsWith("alice-")) {
            return keyId.replaceAll("alice-", "bob-");
        }
        if (keyId.startsWith("bob-")) {
            return keyId.replaceAll("bob-", "alice-");
        }
        throw new AtbashUnexpectedException(String.format("Unrecognized key Id structure '%s'", keyId));
    }

    public String getTenantId(String exchangeId) {
        String result = null;
        for (Map.Entry<String, List<String>> entry : this.exchangeIdsForTenant.entrySet()) {
            for (String id : entry.getValue()) {
                if (!id.equals(exchangeId)) continue;
                result = entry.getKey();
            }
        }
        return result;
    }

    public void removeKeys(String tenantId, String exchangeId) {
        String keyId = exchangeId.startsWith("alice") ? exchangeId.substring(5) : exchangeId.substring(3);
        SelectorCriteria selectorCriteria = SelectorCriteria.newBuilder().withId(keyId).build();
        this.dhKeyManager.removeKeys(tenantId, selectorCriteria);
    }

    public static synchronized DHKeyExchangeManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DHKeyExchangeManager();
            INSTANCE.init();
        }
        return INSTANCE;
    }
}

