/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.util;

import be.atbash.ee.security.octopus.exception.DecryptionFailedException;
import be.atbash.ee.security.octopus.exception.MissingPasswordException;
import be.atbash.util.PublicAPI;
import be.atbash.util.StringUtils;
import be.atbash.util.base64.Base64Codec;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

@PublicAPI
public final class EncryptionHelper {
    private static final String PBKDF_ALGO = "PBKDF2WithHmacSHA1";
    private static final int ITERATION_COUNT = 65556;
    private static final int KEYSIZE = 256;
    private static final String AES = "AES";
    private static final String AES_ALGO = "AES/CBC/PKCS5Padding";
    private static final SecureRandom random = new SecureRandom();

    private EncryptionHelper() {
    }

    public static String encode(String value, char[] password) {
        return EncryptionHelper.encode(value.getBytes(StandardCharsets.UTF_8), password);
    }

    public static String encode(byte[] value, char[] password) {
        if (StringUtils.isEmpty((char[])password)) {
            throw new MissingPasswordException(MissingPasswordException.ObjectType.ENCRYPTION);
        }
        byte[] saltBytes = new byte[20];
        random.nextBytes(saltBytes);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(PBKDF_ALGO);
            PBEKeySpec spec = new PBEKeySpec(password, saltBytes, 65556, 256);
            SecretKey secretKey = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(secretKey.getEncoded(), AES);
            Cipher cipher = Cipher.getInstance(AES_ALGO);
            cipher.init(1, secret);
            AlgorithmParameters params = cipher.getParameters();
            byte[] ivBytes = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] encryptedTextBytes = cipher.doFinal(value);
            byte[] buffer = new byte[saltBytes.length + ivBytes.length + encryptedTextBytes.length];
            System.arraycopy(saltBytes, 0, buffer, 0, saltBytes.length);
            System.arraycopy(ivBytes, 0, buffer, saltBytes.length, ivBytes.length);
            System.arraycopy(encryptedTextBytes, 0, buffer, saltBytes.length + ivBytes.length, encryptedTextBytes.length);
            return Base64Codec.encodeToString((byte[])buffer, (boolean)false);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }

    public static String decode(String encryptedText, char[] password) {
        byte[] decryptedTextBytes;
        if (StringUtils.isEmpty((char[])password)) {
            throw new MissingPasswordException(MissingPasswordException.ObjectType.ENCRYPTION);
        }
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGO);
            ByteBuffer buffer = ByteBuffer.wrap(Base64Codec.decode((String)encryptedText));
            byte[] saltBytes = new byte[20];
            buffer.get(saltBytes, 0, saltBytes.length);
            byte[] ivBytes = new byte[cipher.getBlockSize()];
            buffer.get(ivBytes, 0, ivBytes.length);
            byte[] encryptedTextBytes = new byte[buffer.capacity() - saltBytes.length - ivBytes.length];
            buffer.get(encryptedTextBytes);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(PBKDF_ALGO);
            PBEKeySpec spec = new PBEKeySpec(password, saltBytes, 65556, 256);
            SecretKey secretKey = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(secretKey.getEncoded(), AES);
            cipher.init(2, (Key)secret, new IvParameterSpec(ivBytes));
            decryptedTextBytes = cipher.doFinal(encryptedTextBytes);
        }
        catch (BadPaddingException e) {
            throw new DecryptionFailedException();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return new String(decryptedTextBytes);
    }

    public static String encode(String value, SecretKey secretKey) {
        return EncryptionHelper.encode(value.getBytes(StandardCharsets.UTF_8), secretKey);
    }

    public static String encode(byte[] value, SecretKey secretKey) {
        byte[] saltBytes = new byte[20];
        random.nextBytes(saltBytes);
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGO);
            cipher.init(1, secretKey);
            AlgorithmParameters params = cipher.getParameters();
            byte[] ivBytes = params.getParameterSpec(IvParameterSpec.class).getIV();
            byte[] encryptedTextBytes = cipher.doFinal(value);
            byte[] buffer = new byte[saltBytes.length + ivBytes.length + encryptedTextBytes.length];
            System.arraycopy(saltBytes, 0, buffer, 0, saltBytes.length);
            System.arraycopy(ivBytes, 0, buffer, saltBytes.length, ivBytes.length);
            System.arraycopy(encryptedTextBytes, 0, buffer, saltBytes.length + ivBytes.length, encryptedTextBytes.length);
            return Base64Codec.encodeToString((byte[])buffer, (boolean)true);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }

    public static String decode(String encryptedText, SecretKey secretKey) {
        byte[] decryptedTextBytes;
        try {
            Cipher cipher = Cipher.getInstance(AES_ALGO);
            ByteBuffer buffer = ByteBuffer.wrap(Base64Codec.decode((String)encryptedText));
            byte[] saltBytes = new byte[20];
            buffer.get(saltBytes, 0, saltBytes.length);
            byte[] ivBytes = new byte[cipher.getBlockSize()];
            buffer.get(ivBytes, 0, ivBytes.length);
            byte[] encryptedTextBytes = new byte[buffer.capacity() - saltBytes.length - ivBytes.length];
            buffer.get(encryptedTextBytes);
            SecretKeySpec secret = new SecretKeySpec(secretKey.getEncoded(), AES);
            cipher.init(2, (Key)secret, new IvParameterSpec(ivBytes));
            decryptedTextBytes = cipher.doFinal(encryptedTextBytes);
        }
        catch (BadPaddingException e) {
            throw new DecryptionFailedException();
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return new String(decryptedTextBytes);
    }
}

