/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.writer.encoder;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.writer.KeyEncoderParameters;
import be.atbash.ee.security.octopus.keys.writer.encoder.KeyEncoder;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.SecureRandom;
import org.bouncycastle.openssl.PKCS8Generator;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPKCS8Generator;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8EncryptorBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class PemKeyEncoderPrivatePartPKCS8
implements KeyEncoder {
    @Override
    public byte[] encodeKey(AtbashKey atbashKey, KeyEncoderParameters parameters) throws IOException {
        OutputEncryptor encryptor;
        JceOpenSSLPKCS8EncryptorBuilder encryptorBuilder = new JceOpenSSLPKCS8EncryptorBuilder(PKCS8Generator.AES_256_CBC);
        encryptorBuilder.setRandom(new SecureRandom());
        encryptorBuilder.setPasssword(parameters.getKeyPassword());
        try {
            encryptor = encryptorBuilder.build();
        }
        catch (OperatorCreationException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        JcaPKCS8Generator pkcsGenerator = new JcaPKCS8Generator((PrivateKey)atbashKey.getKey(), encryptor);
        PemObject pemObj = pkcsGenerator.generate();
        StringWriter out = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)out);
        pemWriter.writeObject((PemObjectGenerator)pemObj);
        pemWriter.close();
        return out.toString().getBytes(StandardCharsets.UTF_8);
    }
}

