/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.writer.encoder;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.writer.KeyEncoderParameters;
import be.atbash.ee.security.octopus.keys.writer.encoder.KeyEncoder;
import be.atbash.util.StringUtils;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import org.bouncycastle.openssl.PEMEncryptor;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle.util.io.pem.PemObjectGenerator;

public class PemKeyEncoderPrivatePartPKCS1
implements KeyEncoder {
    @Override
    public byte[] encodeKey(AtbashKey atbashKey, KeyEncoderParameters parameters) throws IOException {
        JcaMiscPEMGenerator generator;
        String encryptionAlg = parameters.getValue("PKCS1.encryption", String.class);
        if (StringUtils.isEmpty((String)encryptionAlg)) {
            generator = new JcaMiscPEMGenerator((Object)atbashKey.getKey());
        } else {
            JcePEMEncryptorBuilder builder = new JcePEMEncryptorBuilder(encryptionAlg);
            builder.setProvider("BC");
            builder.setSecureRandom(new SecureRandom());
            PEMEncryptor encryptor = builder.build(parameters.getKeyPassword());
            generator = new JcaMiscPEMGenerator((Object)atbashKey.getKey(), encryptor);
        }
        StringWriter out = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)out);
        pemWriter.writeObject((PemObjectGenerator)generator);
        pemWriter.close();
        return out.toString().getBytes(StandardCharsets.UTF_8);
    }
}

