/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.writer.encoder;

import be.atbash.ee.security.octopus.config.JwtSupportConfiguration;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.generator.KeyGenerator;
import be.atbash.ee.security.octopus.keys.generator.RSAGenerationParameters;
import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import be.atbash.ee.security.octopus.keys.selector.filter.AsymmetricPartKeyFilter;
import be.atbash.ee.security.octopus.keys.writer.KeyEncoderParameters;
import be.atbash.ee.security.octopus.keys.writer.encoder.KeyEncoder;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Calendar;
import java.util.List;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class KeyStoreEncoder
implements KeyEncoder {
    private JwtSupportConfiguration configuration = JwtSupportConfiguration.getInstance();

    @Override
    public byte[] encodeKey(AtbashKey atbashKey, KeyEncoderParameters parameters) throws IOException {
        KeyStore keyStore = parameters.getKeyStore();
        try {
            KeyStore.Entry entry;
            X509Certificate certificate;
            Key key;
            if (atbashKey.getSecretKeyType().getAsymmetricPart() == AsymmetricPart.PRIVATE) {
                key = (PrivateKey)atbashKey.getKey();
                certificate = this.generateCertificate(this.getPublicKey(key), (PrivateKey)key);
                entry = new KeyStore.PrivateKeyEntry((PrivateKey)key, new X509Certificate[]{certificate});
                keyStore.setEntry(atbashKey.getKeyId(), entry, new KeyStore.PasswordProtection(parameters.getKeyPassword()));
            }
            if (atbashKey.getSecretKeyType().getAsymmetricPart() == AsymmetricPart.PUBLIC) {
                key = (PublicKey)atbashKey.getKey();
                certificate = this.generateCertificate((PublicKey)key, null);
                entry = new KeyStore.TrustedCertificateEntry(certificate);
                keyStore.setEntry(atbashKey.getKeyId(), entry, null);
            }
            if (atbashKey.getSecretKeyType().getAsymmetricPart() == AsymmetricPart.SYMMETRIC) {
                key = (SecretKey)atbashKey.getKey();
                keyStore.setKeyEntry(atbashKey.getKeyId(), key, parameters.getKeyPassword(), null);
            }
        }
        catch (KeyStoreException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            keyStore.store(stream, parameters.getFilePassword());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return stream.toByteArray();
    }

    private X509Certificate generateCertificate(PublicKey publicKey, PrivateKey privateKey) {
        try {
            Calendar start = Calendar.getInstance();
            Calendar expiry = Calendar.getInstance();
            expiry.add(1, 1);
            X500Name name = new X500Name(this.configuration.getNameCertificateKeyStore());
            X509v3CertificateBuilder certificateBuilder = new X509v3CertificateBuilder(name, BigInteger.ONE, start.getTime(), expiry.getTime(), name, SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()));
            if (privateKey == null) {
                privateKey = this.createSigningKey();
            }
            ContentSigner signer = new JcaContentSignerBuilder(this.configuration.getCertificateSignatureAlgorithm()).setProvider((Provider)new BouncyCastleProvider()).build(privateKey);
            X509CertificateHolder holder = certificateBuilder.build(signer);
            return new JcaX509CertificateConverter().setProvider((Provider)new BouncyCastleProvider()).getCertificate(holder);
        }
        catch (GeneralSecurityException | OperatorCreationException ex) {
            throw new AtbashUnexpectedException(ex);
        }
    }

    private PublicKey getPublicKey(Key key) {
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)key;
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent());
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePublic(publicKeySpec);
            }
            catch (Exception e) {
                throw new AtbashUnexpectedException((Throwable)e);
            }
        }
        throw new UnsupportedOperationException("TODO");
    }

    private PrivateKey createSigningKey() {
        RSAGenerationParameters generationParameters = ((RSAGenerationParameters.RSAGenerationParametersBuilder)new RSAGenerationParameters.RSAGenerationParametersBuilder().withKeyId("cert-signing")).build();
        KeyGenerator generator = new KeyGenerator();
        List<AtbashKey> atbashKeys = generator.generateKeys(generationParameters);
        AsymmetricPartKeyFilter keyFilter = new AsymmetricPartKeyFilter(AsymmetricPart.PRIVATE);
        List<AtbashKey> privateKeys = keyFilter.filter(atbashKeys);
        return (PrivateKey)privateKeys.get(0).getKey();
    }
}

