/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.writer.encoder;

import be.atbash.ee.security.octopus.UnsupportedKeyType;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.writer.KeyEncoderParameters;
import be.atbash.ee.security.octopus.keys.writer.encoder.KeyEncoder;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;

public class JwkKeyEncoderPublicPart
implements KeyEncoder {
    @Override
    public byte[] encodeKey(AtbashKey atbashKey, KeyEncoderParameters parameters) throws IOException {
        if (KeyType.RSA.equals((Object)atbashKey.getSecretKeyType().getKeyType())) {
            return this.encodeRSAKey(atbashKey);
        }
        if (KeyType.EC.equals((Object)atbashKey.getSecretKeyType().getKeyType())) {
            return this.encodeECKey(atbashKey);
        }
        throw new UnsupportedKeyType(atbashKey.getSecretKeyType().getKeyType(), "writing JWK");
    }

    private byte[] encodeRSAKey(AtbashKey atbashKey) {
        RSAKey rsaKey = new RSAKey.Builder((RSAPublicKey)atbashKey.getKey()).keyID(atbashKey.getKeyId()).build();
        return rsaKey.toJSONObject().toJSONString().getBytes(StandardCharsets.UTF_8);
    }

    private byte[] encodeECKey(AtbashKey atbashKey) {
        Curve curve;
        try {
            curve = this.deriveCurve((PublicKey)atbashKey.getKey());
        }
        catch (GeneralSecurityException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        ECKey ecKey = new ECKey.Builder(curve, (ECPublicKey)atbashKey.getKey()).keyID(atbashKey.getKeyId()).build();
        return ecKey.toJSONObject().toJSONString().getBytes(StandardCharsets.UTF_8);
    }

    private Curve deriveCurve(org.bouncycastle.jce.spec.ECParameterSpec ecParameterSpec) throws GeneralSecurityException {
        for (Curve supportedCurve : ECKey.SUPPORTED_CURVES) {
            String name = supportedCurve.getName();
            X9ECParameters params = ECNamedCurveTable.getByName((String)name);
            if (params == null || !params.getN().equals(ecParameterSpec.getN()) || !params.getH().equals(ecParameterSpec.getH()) || !params.getCurve().equals(ecParameterSpec.getCurve()) || !params.getG().equals(ecParameterSpec.getG())) continue;
            return supportedCurve;
        }
        throw new GeneralSecurityException("Could not find name for curve");
    }

    private Curve deriveCurve(PublicKey publicKey) throws GeneralSecurityException {
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey pk = (ECPublicKey)publicKey;
            ECParameterSpec params = pk.getParams();
            return this.deriveCurve(EC5Util.convertSpec((ECParameterSpec)params, (boolean)false));
        }
        if (publicKey instanceof org.bouncycastle.jce.interfaces.ECPublicKey) {
            org.bouncycastle.jce.interfaces.ECPublicKey pk = (org.bouncycastle.jce.interfaces.ECPublicKey)publicKey;
            return this.deriveCurve(pk.getParameters());
        }
        throw new IllegalArgumentException("Can only be used with instances of ECPublicKey (either jce or bc implementation)");
    }
}

