/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.writer.encoder;

import be.atbash.ee.security.octopus.UnsupportedKeyType;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.writer.KeyEncoderParameters;
import be.atbash.ee.security.octopus.keys.writer.encoder.KeyEncoder;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class JwkKeyEncoderPrivatePart
implements KeyEncoder {
    public JwkKeyEncoderPrivatePart() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Override
    public byte[] encodeKey(AtbashKey atbashKey, KeyEncoderParameters parameters) throws IOException {
        if (KeyType.RSA.equals((Object)atbashKey.getSecretKeyType().getKeyType())) {
            return this.encodeRSAKey(atbashKey);
        }
        if (KeyType.EC.equals((Object)atbashKey.getSecretKeyType().getKeyType())) {
            return this.encodeECKey(atbashKey);
        }
        throw new UnsupportedKeyType(atbashKey.getSecretKeyType().getKeyType(), "writing JWK");
    }

    private byte[] encodeRSAKey(AtbashKey atbashKey) {
        RSAKey rsaKey = new RSAKey.Builder((RSAPublicKey)this.getPublicKey(atbashKey.getKey())).keyID(atbashKey.getKeyId()).privateKey((RSAPrivateKey)atbashKey.getKey()).build();
        return rsaKey.toJSONObject().toJSONString().getBytes(StandardCharsets.UTF_8);
    }

    private byte[] encodeECKey(AtbashKey atbashKey) {
        Curve curve;
        try {
            curve = this.deriveCurve((PrivateKey)atbashKey.getKey());
        }
        catch (GeneralSecurityException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        ECKey jwk = new ECKey.Builder(curve, (ECPublicKey)this.getPublicKey(atbashKey.getKey(), curve)).keyID(atbashKey.getKeyId()).privateKey((java.security.interfaces.ECPrivateKey)atbashKey.getKey()).build();
        return jwk.toJSONObject().toJSONString().getBytes(StandardCharsets.UTF_8);
    }

    private Curve deriveCurve(org.bouncycastle.jce.spec.ECParameterSpec ecParameterSpec) throws GeneralSecurityException {
        for (Curve supportedCurve : ECKey.SUPPORTED_CURVES) {
            String name = supportedCurve.getName();
            X9ECParameters params = ECNamedCurveTable.getByName((String)name);
            if (params == null || !params.getN().equals(ecParameterSpec.getN()) || !params.getH().equals(ecParameterSpec.getH()) || !params.getCurve().equals(ecParameterSpec.getCurve()) || !params.getG().equals(ecParameterSpec.getG())) continue;
            return supportedCurve;
        }
        throw new GeneralSecurityException("Could not find name for curve");
    }

    private Curve deriveCurve(PrivateKey privateKey) throws GeneralSecurityException {
        if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
            java.security.interfaces.ECPrivateKey pk = (java.security.interfaces.ECPrivateKey)privateKey;
            ECParameterSpec params = pk.getParams();
            return this.deriveCurve(EC5Util.convertSpec((ECParameterSpec)params, (boolean)false));
        }
        if (privateKey instanceof ECPrivateKey) {
            ECPrivateKey pk = (ECPrivateKey)privateKey;
            return this.deriveCurve(pk.getParameters());
        }
        throw new IllegalArgumentException("Can only be used with instances of ECPrivateKey (either jce or bc implementation)");
    }

    private PublicKey getPublicKey(Key key) {
        if (key instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)key;
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent());
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                return keyFactory.generatePublic(publicKeySpec);
            }
            catch (Exception e) {
                throw new AtbashUnexpectedException((Throwable)e);
            }
        }
        throw new UnsupportedOperationException("TODO");
    }

    private PublicKey getPublicKey(Key key, Curve curve) {
        if (key instanceof java.security.interfaces.ECPrivateKey && key instanceof ECPrivateKey) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("ECDSA", "BC");
                ECNamedCurveParameterSpec ecSpec = org.bouncycastle.jce.ECNamedCurveTable.getParameterSpec((String)curve.getStdName());
                ECPoint q = ecSpec.getG().multiply(((ECPrivateKey)key).getD());
                ECPublicKeySpec pubSpec = new ECPublicKeySpec(q, (org.bouncycastle.jce.spec.ECParameterSpec)ecSpec);
                return keyFactory.generatePublic((KeySpec)pubSpec);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
                throw new AtbashUnexpectedException((Throwable)e);
            }
        }
        throw new UnsupportedOperationException("TODO");
    }
}

