/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.writer;

import be.atbash.ee.security.octopus.config.PemKeyEncryption;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import be.atbash.ee.security.octopus.keys.writer.KeyEncoderParameters;
import be.atbash.ee.security.octopus.keys.writer.encoder.JwkKeyEncoderPrivatePart;
import be.atbash.ee.security.octopus.keys.writer.encoder.JwkKeyEncoderPublicPart;
import be.atbash.ee.security.octopus.keys.writer.encoder.KeyStoreEncoder;
import be.atbash.ee.security.octopus.keys.writer.encoder.PemKeyEncoderPrivatePartNotEncrypted;
import be.atbash.ee.security.octopus.keys.writer.encoder.PemKeyEncoderPrivatePartPKCS1;
import be.atbash.ee.security.octopus.keys.writer.encoder.PemKeyEncoderPrivatePartPKCS8;
import be.atbash.ee.security.octopus.keys.writer.encoder.PemKeyEncoderPublicPart;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class KeyWriterFactory {
    private PemKeyEncoderPrivatePartNotEncrypted notEncryptedEncoder;
    private PemKeyEncoderPublicPart publicPartEncoder;
    private PemKeyEncoderPrivatePartPKCS1 privatePartPKCS1Encoder;
    private PemKeyEncoderPrivatePartPKCS8 privatePartPKCS8Encoder;
    private JwkKeyEncoderPrivatePart privatePartJwkEncoder;
    private JwkKeyEncoderPublicPart publicPartJwkEncoder;
    private KeyStoreEncoder keyStoreEncoder;

    @PostConstruct
    public void init() {
        this.notEncryptedEncoder = new PemKeyEncoderPrivatePartNotEncrypted();
        this.publicPartEncoder = new PemKeyEncoderPublicPart();
        this.privatePartPKCS1Encoder = new PemKeyEncoderPrivatePartPKCS1();
        this.privatePartPKCS8Encoder = new PemKeyEncoderPrivatePartPKCS8();
        this.privatePartJwkEncoder = new JwkKeyEncoderPrivatePart();
        this.publicPartJwkEncoder = new JwkKeyEncoderPublicPart();
        this.keyStoreEncoder = new KeyStoreEncoder();
    }

    public byte[] writeKeyAsKeyStore(AtbashKey atbashKey, KeyEncoderParameters parameters) throws IOException {
        return this.keyStoreEncoder.encodeKey(atbashKey, parameters);
    }

    public byte[] writeKeyAsJWK(AtbashKey atbashKey, KeyEncoderParameters parameters) throws IOException {
        if (atbashKey.getSecretKeyType().getAsymmetricPart() == AsymmetricPart.PRIVATE) {
            return this.privatePartJwkEncoder.encodeKey(atbashKey, parameters);
        }
        return this.publicPartJwkEncoder.encodeKey(atbashKey, parameters);
    }

    public byte[] writeKeyAsPEM(AtbashKey atbashKey, KeyEncoderParameters parameters) throws IOException {
        byte[] result;
        if (atbashKey.getSecretKeyType().getAsymmetricPart() == AsymmetricPart.PRIVATE) {
            PemKeyEncryption pemKeyEncryption = parameters.getValue(PemKeyEncryption.class);
            switch (pemKeyEncryption) {
                case NONE: {
                    result = this.notEncryptedEncoder.encodeKey(atbashKey, parameters);
                    break;
                }
                case PKCS8: {
                    result = this.privatePartPKCS8Encoder.encodeKey(atbashKey, parameters);
                    break;
                }
                case PKCS1: {
                    result = this.privatePartPKCS1Encoder.encodeKey(atbashKey, parameters);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported value for PemKeyEncryption : %s", new Object[]{pemKeyEncryption}));
                }
            }
        } else {
            result = this.publicPartEncoder.encodeKey(atbashKey, parameters);
        }
        return result;
    }

    public byte[] writeKeyAsJWKSet(AtbashKey atbashKey, KeyEncoderParameters parameters) throws IOException {
        byte[] result;
        String jwkJSON = new String(this.writeKeyAsJWK(atbashKey, parameters));
        try {
            JWK jwk = JWK.parse((String)jwkJSON);
            ArrayList<JWK> jwks = new ArrayList<JWK>();
            jwks.add(jwk);
            jwks.addAll(parameters.getJwkSet().getKeys());
            JWKSet jwkSet = new JWKSet(jwks);
            result = jwkSet.toJSONObject(false).toJSONString().getBytes(StandardCharsets.UTF_8);
        }
        catch (ParseException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return result;
    }
}

