/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.writer;

import be.atbash.ee.security.octopus.config.JwtSupportConfiguration;
import be.atbash.ee.security.octopus.config.PemKeyEncryption;
import be.atbash.ee.security.octopus.exception.MissingPasswordException;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.reader.KeyResourceType;
import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import be.atbash.ee.security.octopus.keys.writer.KeyEncoderParameters;
import be.atbash.ee.security.octopus.keys.writer.KeyResourceLocationException;
import be.atbash.ee.security.octopus.keys.writer.KeyWriterFactory;
import be.atbash.util.PublicAPI;
import be.atbash.util.StringUtils;
import be.atbash.util.exception.AtbashUnexpectedException;
import be.atbash.util.resource.ResourceUtil;
import com.nimbusds.jose.jwk.JWKSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.text.ParseException;
import java.util.Scanner;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@PublicAPI
@ApplicationScoped
public class KeyWriter {
    @Inject
    private JwtSupportConfiguration jwtSupportConfiguration;
    @Inject
    private KeyWriterFactory keyWriterFactory;
    @Inject
    private ResourceUtil resourceUtil;

    public void writeKeyResource(AtbashKey atbashKey, KeyResourceType keyResourceType, String target, char[] keyPasssword, char[] filePassword) {
        this.checkDependencies();
        try {
            switch (keyResourceType) {
                case JWK: {
                    this.checkTargetFile(target, true);
                    byte[] content = this.writeKeyAsJWK(atbashKey, keyPasssword);
                    this.writeFile(target, content);
                    break;
                }
                case JWKSET: {
                    this.checkTargetFile(target, false);
                    JWKSet jwkSet = this.loadExistingJWKSet(target);
                    byte[] content = this.writeKeyAsJWKSet(atbashKey, jwkSet);
                    this.writeFile(target, content);
                    break;
                }
                case PEM: {
                    this.checkTargetFile(target, true);
                    byte[] content = this.writeKeyAsPEM(atbashKey, keyPasssword);
                    this.writeFile(target, content);
                    break;
                }
                case KEYSTORE: {
                    this.checkTargetFile(target, false);
                    KeyStore keyStore = this.loadExistingKeyStore(target, filePassword);
                    byte[] content = this.writeKeyAsKeyStore(atbashKey, keyPasssword, filePassword, keyStore);
                    this.writeFile(target, content);
                }
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }

    private byte[] writeKeyAsJWKSet(AtbashKey atbashKey, JWKSet jwkSet) throws IOException {
        KeyEncoderParameters parameters = new KeyEncoderParameters(jwkSet);
        return this.keyWriterFactory.writeKeyAsJWKSet(atbashKey, parameters);
    }

    private JWKSet loadExistingJWKSet(String target) {
        JWKSet result;
        InputStream inputStream = null;
        try {
            if (this.resourceUtil.resourceExists(target)) {
                inputStream = this.resourceUtil.getStream(target);
            }
        }
        catch (IOException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        if (inputStream == null) {
            result = new JWKSet();
        } else {
            String fileContent = new Scanner(inputStream).useDelimiter("\\Z").next();
            try {
                result = JWKSet.parse((String)fileContent);
            }
            catch (ParseException e) {
                throw new AtbashUnexpectedException((Throwable)e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new AtbashUnexpectedException((Throwable)e);
                }
            }
        }
        return result;
    }

    private KeyStore loadExistingKeyStore(String target, char[] filePassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore keyStore = KeyStore.getInstance(this.jwtSupportConfiguration.getKeyStoreType());
        if (this.resourceUtil.resourceExists(target)) {
            InputStream inputStream = this.resourceUtil.getStream(target);
            keyStore.load(inputStream, filePassword);
        } else {
            keyStore.load(null, null);
        }
        return keyStore;
    }

    private void writeFile(String target, byte[] fileContent) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(target);){
            outputStream.write(fileContent);
        }
    }

    public byte[] writeKeyResource(AtbashKey atbashKey, KeyResourceType keyResourceType, char[] keyPassword, char[] filePassword) {
        byte[] result;
        this.checkDependencies();
        try {
            switch (keyResourceType) {
                case JWK: {
                    result = this.writeKeyAsJWK(atbashKey, keyPassword);
                    break;
                }
                case JWKSET: {
                    result = this.writeKeyAsJWKSet(atbashKey, new JWKSet());
                    break;
                }
                case PEM: {
                    result = this.writeKeyAsPEM(atbashKey, keyPassword);
                    break;
                }
                case KEYSTORE: {
                    KeyStore keyStore = KeyStore.getInstance(this.jwtSupportConfiguration.getKeyStoreType());
                    keyStore.load(null, null);
                    result = this.writeKeyAsKeyStore(atbashKey, keyPassword, filePassword, keyStore);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported value for KeyResourceType : %s", new Object[]{keyResourceType}));
                }
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return result;
    }

    private byte[] writeKeyAsPEM(AtbashKey atbashKey, char[] keyPassword) throws IOException {
        if (this.jwtSupportConfiguration.getPemKeyEncryption() != PemKeyEncryption.NONE) {
            boolean checkRequired = true;
            if (this.jwtSupportConfiguration.getPemKeyEncryption() == PemKeyEncryption.PKCS1 && StringUtils.isEmpty((String)this.jwtSupportConfiguration.getPKCS1EncryptionAlgorithm())) {
                checkRequired = false;
            }
            if (checkRequired) {
                this.checkKeyPassword(atbashKey, keyPassword);
            }
        }
        KeyEncoderParameters parameters = new KeyEncoderParameters(keyPassword);
        parameters.addValue(PemKeyEncryption.class, (Object)this.jwtSupportConfiguration.getPemKeyEncryption());
        parameters.addValue("PKCS1.encryption", (Object)this.jwtSupportConfiguration.getPKCS1EncryptionAlgorithm());
        return this.keyWriterFactory.writeKeyAsPEM(atbashKey, parameters);
    }

    private byte[] writeKeyAsKeyStore(AtbashKey atbashKey, char[] keyPassword, char[] filePassword, KeyStore keyStore) throws IOException {
        this.checkKeyPassword(atbashKey, keyPassword);
        if (StringUtils.isEmpty((char[])filePassword)) {
            throw new MissingPasswordException(MissingPasswordException.ObjectType.STORE, "A password for the keystore is required in order to save the key info");
        }
        KeyEncoderParameters parameters = new KeyEncoderParameters(keyPassword, filePassword, keyStore);
        return this.keyWriterFactory.writeKeyAsKeyStore(atbashKey, parameters);
    }

    private byte[] writeKeyAsJWK(AtbashKey atbashKey, char[] keyPassword) throws IOException {
        KeyEncoderParameters parameters = new KeyEncoderParameters(keyPassword);
        return this.keyWriterFactory.writeKeyAsJWK(atbashKey, parameters);
    }

    private void checkTargetFile(String target, boolean existingCheck) {
        File file = new File(target);
        if (file.isDirectory()) {
            throw new KeyResourceLocationException(String.format("Location '%s' denotes a directory and must point to a file", target));
        }
        if (existingCheck && file.exists()) {
            throw new KeyResourceLocationException(String.format("File '%s' already exists and overwrite is not allowed for this key resource type", target));
        }
        boolean fileExists = file.exists();
        if (fileExists && !file.canWrite()) {
            throw new KeyResourceLocationException(String.format("File '%s' must be writable", target));
        }
        if (!fileExists) {
            File parentDirectory = file.getParentFile();
            if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
                throw new AtbashUnexpectedException(String.format("Directory %s could not be created", parentDirectory.getAbsolutePath()));
            }
        } else if (!file.canRead() || !file.canWrite()) {
            throw new KeyResourceLocationException(String.format("File '%s' must be readable and writable", target));
        }
    }

    private void checkKeyPassword(AtbashKey atbashKey, char[] keyPasssword) {
        if (atbashKey.getSecretKeyType().isAsymmetric() && atbashKey.getSecretKeyType().getAsymmetricPart() == AsymmetricPart.PRIVATE && StringUtils.isEmpty((char[])keyPasssword)) {
            throw new MissingPasswordException(MissingPasswordException.ObjectType.STORE, "A passphrase is required in order to save the key info");
        }
    }

    private void checkDependencies() {
        if (this.keyWriterFactory == null) {
            this.keyWriterFactory = new KeyWriterFactory();
            this.keyWriterFactory.init();
            this.jwtSupportConfiguration = JwtSupportConfiguration.getInstance();
            this.resourceUtil = ResourceUtil.getInstance();
        }
    }
}

