/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.writer;

import com.nimbusds.jose.jwk.JWKSet;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;

public class KeyEncoderParameters {
    private char[] keyPassword;
    private char[] filePassword;
    private KeyStore keyStore;
    private JWKSet jwkSet;
    private Map<Object, Object> additionalValues;

    public KeyEncoderParameters() {
        this.additionalValues = new HashMap<Object, Object>();
    }

    public KeyEncoderParameters(char[] keyPassword) {
        this();
        this.keyPassword = keyPassword;
    }

    public KeyEncoderParameters(JWKSet jwkSet) {
        this.jwkSet = jwkSet;
    }

    public KeyEncoderParameters(char[] keyPassword, char[] filePassword, KeyStore keyStore) {
        this();
        this.keyPassword = keyPassword;
        this.filePassword = filePassword;
        this.keyStore = keyStore;
    }

    public void addValue(Class<?> keyClass, Object value) {
        this.additionalValues.put(keyClass, value);
    }

    public void addValue(String key, Object value) {
        this.additionalValues.put(key, value);
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public char[] getFilePassword() {
        return this.filePassword;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public JWKSet getJwkSet() {
        return this.jwkSet;
    }

    public <T> T getValue(Class<T> keyClass) {
        return (T)this.additionalValues.get(keyClass);
    }

    public <T> T getValue(String key, Class<T> valueClass) {
        return (T)this.additionalValues.get(key);
    }
}

