/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.selector.filter;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.selector.filter.KeyFilter;
import be.atbash.util.exception.AtbashIllegalActionException;
import com.nimbusds.jose.jwk.KeyType;
import java.util.ArrayList;
import java.util.List;

public class KeyTypeKeyFilter
implements KeyFilter {
    private KeyType keyType;

    public KeyTypeKeyFilter(KeyType keyType) {
        if (keyType == null) {
            throw new AtbashIllegalActionException("(OCT-DEV-110) Key Type to search can't be null.");
        }
        this.keyType = keyType;
    }

    @Override
    public List<AtbashKey> filter(List<AtbashKey> keys) {
        if (keys == null) {
            throw new AtbashIllegalActionException("(OCT-DEV-103) List of keys to filter can't be null.");
        }
        ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
        for (AtbashKey key : keys) {
            if (!this.keyType.equals((Object)key.getSecretKeyType().getKeyType())) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    public String describe() {
        return String.format("KeyFilter{keyType='%s'}", this.keyType.getValue());
    }
}

