/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.selector.filter;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.selector.filter.KeyFilter;
import be.atbash.util.StringUtils;
import be.atbash.util.exception.AtbashIllegalActionException;
import java.util.ArrayList;
import java.util.List;

public class IdKeyFilter
implements KeyFilter {
    private String keyId;

    public IdKeyFilter(String keyId) {
        if (StringUtils.isEmpty((String)keyId)) {
            throw new AtbashIllegalActionException("(OCT-DEV-102) Key Id to search can't be null or empty");
        }
        this.keyId = keyId;
    }

    @Override
    public List<AtbashKey> filter(List<AtbashKey> keys) {
        if (keys == null) {
            throw new AtbashIllegalActionException("(OCT-DEV-103) List of keys to filter can't be null");
        }
        ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
        for (AtbashKey key : keys) {
            if (!this.keyId.equals(key.getKeyId())) continue;
            result.add(key);
        }
        return result;
    }

    public String getKeyId() {
        return this.keyId;
    }

    @Override
    public String describe() {
        return String.format("KeyFilter{keyId='%s'}", this.keyId);
    }
}

