/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.selector.filter;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import be.atbash.ee.security.octopus.keys.selector.filter.KeyFilter;
import be.atbash.util.exception.AtbashIllegalActionException;
import java.util.ArrayList;
import java.util.List;

public class AsymmetricPartKeyFilter
implements KeyFilter {
    private AsymmetricPart asymmetricPart;

    public AsymmetricPartKeyFilter(AsymmetricPart asymmetricPart) {
        this.asymmetricPart = asymmetricPart;
    }

    @Override
    public List<AtbashKey> filter(List<AtbashKey> keys) {
        if (keys == null) {
            throw new AtbashIllegalActionException("(OCT-DEV-103) List of keys to filter can't be null");
        }
        ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
        for (AtbashKey key : keys) {
            if (!this.asymmetricPart.equals((Object)key.getSecretKeyType().getAsymmetricPart())) continue;
            result.add(key);
        }
        return result;
    }

    @Override
    public String describe() {
        return String.format("KeyFilter{part='%s'}", this.asymmetricPart.name());
    }
}

