/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.selector;

import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import be.atbash.ee.security.octopus.keys.selector.SecretKeyType;
import be.atbash.ee.security.octopus.keys.selector.filter.AsymmetricPartKeyFilter;
import be.atbash.ee.security.octopus.keys.selector.filter.IdKeyFilter;
import be.atbash.ee.security.octopus.keys.selector.filter.KeyFilter;
import be.atbash.ee.security.octopus.keys.selector.filter.KeyTypeKeyFilter;
import be.atbash.ee.security.octopus.keys.selector.filter.SecretKeyTypeKeyFilter;
import be.atbash.util.PublicAPI;
import be.atbash.util.StringUtils;
import com.nimbusds.jose.jwk.KeyType;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

@PublicAPI
public class SelectorCriteria {
    private String id;
    private SecretKeyType secretKeyType;
    private KeyType keyType;
    private AsymmetricPart asymmetricPart;
    private URI jku;
    private Object discriminator;

    private SelectorCriteria() {
    }

    public String getId() {
        return this.id;
    }

    public SecretKeyType getSecretKeyType() {
        return this.secretKeyType;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public AsymmetricPart getAsymmetricPart() {
        return this.asymmetricPart;
    }

    public URI getJku() {
        return this.jku;
    }

    public Object getDiscriminator() {
        return this.discriminator;
    }

    public List<KeyFilter> asKeyFilters() {
        ArrayList<KeyFilter> result = new ArrayList<KeyFilter>();
        if (StringUtils.hasText((String)this.id)) {
            result.add(new IdKeyFilter(this.id));
        }
        if (this.secretKeyType != null) {
            result.add(new SecretKeyTypeKeyFilter(this.secretKeyType));
        }
        if (this.keyType != null) {
            result.add(new KeyTypeKeyFilter(this.keyType));
        }
        if (this.asymmetricPart != null) {
            result.add(new AsymmetricPartKeyFilter(this.asymmetricPart));
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("KeySelectorCriteria{");
        for (KeyFilter keyFilter : this.asKeyFilters()) {
            result.append("\n     ").append(keyFilter.describe());
        }
        result.append("\n}");
        return result.toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @PublicAPI
    public static class Builder {
        private SelectorCriteria criteria = new SelectorCriteria();

        private Builder() {
        }

        public Builder withId(String id) {
            this.criteria.id = id;
            return this;
        }

        public Builder withSecretKeyType(SecretKeyType secretKeyType) {
            this.criteria.secretKeyType = secretKeyType;
            return this;
        }

        public Builder withKeyType(KeyType keyType) {
            this.criteria.keyType = keyType;
            return this;
        }

        public Builder withAsymmetricPart(AsymmetricPart asymmetricPart) {
            this.criteria.asymmetricPart = asymmetricPart;
            return this;
        }

        public Builder withJKU(URI jku) {
            this.criteria.jku = jku;
            return this;
        }

        public Builder withDiscriminator(Object discriminator) {
            this.criteria.discriminator = discriminator;
            return this;
        }

        public SelectorCriteria build() {
            return this.criteria;
        }
    }
}

