/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.selector;

import be.atbash.ee.security.octopus.keys.generator.DHGenerationParameters;
import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import be.atbash.util.exception.AtbashIllegalActionException;
import com.nimbusds.jose.jwk.KeyType;
import java.security.Key;
import java.security.PrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHKey;

public class SecretKeyType {
    private KeyType keyType;
    private AsymmetricPart asymmetricPart;

    public SecretKeyType(KeyType keyType) {
        this(keyType, AsymmetricPart.SYMMETRIC);
    }

    public SecretKeyType(KeyType keyType, AsymmetricPart asymmetricPart) {
        if (keyType == null) {
            throw new AtbashIllegalActionException("(OCT-DEV-107) Parameter KeyType can't be null");
        }
        if (keyType == KeyType.OCT) {
            if (asymmetricPart != AsymmetricPart.SYMMETRIC) {
                throw new AtbashIllegalActionException("(OCT-DEV-109) AsymmetricPart can't be specified for a symmetric key type");
            }
        } else if (asymmetricPart == null || asymmetricPart == AsymmetricPart.SYMMETRIC) {
            throw new AtbashIllegalActionException("(OCT-DEV-108) Parameter AsymmetricPart is required for a asymmetric key type");
        }
        this.keyType = keyType;
        this.asymmetricPart = asymmetricPart;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public AsymmetricPart getAsymmetricPart() {
        return this.asymmetricPart;
    }

    public boolean isAsymmetric() {
        return this.asymmetricPart != null && this.asymmetricPart != AsymmetricPart.SYMMETRIC;
    }

    public boolean isPrivate() {
        return this.isAsymmetric() && this.asymmetricPart == AsymmetricPart.PRIVATE;
    }

    public static SecretKeyType fromKey(Key key) {
        SecretKeyType result = null;
        if (key instanceof RSAKey) {
            result = new SecretKeyType(KeyType.RSA, SecretKeyType.determineAsymmetricPart(key));
        }
        if (key instanceof ECKey) {
            result = new SecretKeyType(KeyType.EC, SecretKeyType.determineAsymmetricPart(key));
        }
        if (key instanceof SecretKey) {
            result = new SecretKeyType(KeyType.OCT);
        }
        if (key instanceof DHKey) {
            result = new SecretKeyType(DHGenerationParameters.DH, SecretKeyType.determineAsymmetricPart(key));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Unsupported Key instance %s", key.getClass().getName()));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecretKeyType)) {
            return false;
        }
        SecretKeyType that = (SecretKeyType)o;
        if (!this.keyType.equals((Object)that.keyType)) {
            return false;
        }
        return this.asymmetricPart == that.asymmetricPart;
    }

    public int hashCode() {
        int result = this.keyType.hashCode();
        result = 31 * result + (this.asymmetricPart != null ? this.asymmetricPart.hashCode() : 0);
        return result;
    }

    private static AsymmetricPart determineAsymmetricPart(Key key) {
        return key instanceof PrivateKey ? AsymmetricPart.PRIVATE : AsymmetricPart.PUBLIC;
    }
}

