/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.selector;

import be.atbash.ee.security.octopus.config.JwtSupportConfiguration;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.KeyManager;
import be.atbash.ee.security.octopus.keys.selector.SelectorCriteria;
import be.atbash.util.CDIUtils;
import be.atbash.util.PublicAPI;
import java.lang.annotation.Annotation;
import java.security.Key;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
@PublicAPI
public class KeySelector {
    private KeyManager keyManager;

    @PostConstruct
    public void init() {
        this.keyManager = (KeyManager)CDIUtils.retrieveOptionalInstance(KeyManager.class, (Annotation[])new Annotation[0]);
    }

    public <T extends Key> T selectSecretKey(SelectorCriteria selectorCriteria) {
        AtbashKey key = this.selectAtbashKey(selectorCriteria);
        if (key == null) {
            return null;
        }
        return (T)key.getKey();
    }

    public AtbashKey selectAtbashKey(SelectorCriteria selectorCriteria) {
        this.checkDependencies();
        List<AtbashKey> keys = this.keyManager.retrieveKeys(selectorCriteria);
        if (keys.isEmpty() || keys.size() > 1) {
            return null;
        }
        return keys.get(0);
    }

    private synchronized void checkDependencies() {
        if (this.keyManager == null) {
            this.keyManager = this.getKeyManager();
        }
    }

    protected KeyManager getKeyManager() {
        JwtSupportConfiguration configuration = JwtSupportConfiguration.getInstance();
        return configuration.getKeyManager();
    }
}

