/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.reader.password;

import be.atbash.config.exception.ConfigurationException;
import be.atbash.ee.security.octopus.keys.reader.password.KeyResourcePasswordLookup;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class ConfigKeyResourcePasswordLookup
implements KeyResourcePasswordLookup {
    private static final String KEY_PREFIX = "atbash.key.pwd.";
    private Map<ConfigKey, char[]> passwords = this.readPasswordsFromConfig();

    @Override
    public char[] getResourcePassword(String resourcePath) {
        this.checkDependencies();
        char[] result = new char[]{};
        String path = ConfigKeyResourcePasswordLookup.stripPrefix(resourcePath);
        for (Map.Entry<ConfigKey, char[]> entry : this.passwords.entrySet()) {
            if (!entry.getKey().isMatch(path, null)) continue;
            result = entry.getValue();
        }
        return result;
    }

    private static String stripPrefix(String resourcePath) {
        return resourcePath.substring(resourcePath.indexOf(58) + 1);
    }

    @Override
    public char[] getKeyPassword(String resourcePath, String keyId) {
        this.checkDependencies();
        char[] result = new char[]{};
        String path = ConfigKeyResourcePasswordLookup.stripPrefix(resourcePath);
        for (Map.Entry<ConfigKey, char[]> entry : this.passwords.entrySet()) {
            if (!entry.getKey().isMatch(path, keyId)) continue;
            result = entry.getValue();
        }
        if (result.length == 0) {
            for (Map.Entry<ConfigKey, char[]> entry : this.passwords.entrySet()) {
                if (!entry.getKey().isMatch(path, null)) continue;
                result = entry.getValue();
            }
        }
        return result;
    }

    private void checkDependencies() {
        if (this.passwords == null) {
            this.passwords = this.readPasswordsFromConfig();
        }
    }

    private Map<ConfigKey, char[]> readPasswordsFromConfig() {
        HashMap<ConfigKey, char[]> result = new HashMap<ConfigKey, char[]>();
        Config config = ConfigProvider.getConfig();
        if (config.getPropertyNames() == null) {
            return result;
        }
        for (String configKeyName : config.getPropertyNames()) {
            String alias;
            if (!configKeyName.startsWith(KEY_PREFIX)) continue;
            String value = (String)config.getValue(configKeyName, String.class);
            String[] parts = this.determineParts(configKeyName);
            if (parts.length == 1) {
                result.put(new ConfigKey(parts[0]), value.toCharArray());
                continue;
            }
            try {
                alias = URLDecoder.decode(parts[1], "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new ConfigurationException(String.format("config key uses invalid encoding '%s'", parts[1]));
            }
            result.put(new ConfigKey(parts[0], alias), value.toCharArray());
        }
        return result;
    }

    public String toString() {
        return "class " + ConfigKeyResourcePasswordLookup.class.getName();
    }

    private String[] determineParts(String keyName) {
        return keyName.substring(KEY_PREFIX.length()).split("!", 2);
    }

    private class ConfigKey {
        private String path;
        private String keyId;

        public ConfigKey(String path, String keyId) {
            this.path = path;
            this.keyId = keyId;
        }

        public ConfigKey(String path) {
            this(path, null);
        }

        public String getPath() {
            return this.path;
        }

        public String getKeyId() {
            return this.keyId;
        }

        public boolean isMatch(String path, String keyId) {
            if (this.path.equals(path)) {
                if (this.keyId == null) {
                    return keyId == null;
                }
                return this.keyId.equals(keyId);
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConfigKey)) {
                return false;
            }
            ConfigKey configKey = (ConfigKey)o;
            if (!this.path.equals(configKey.path)) {
                return false;
            }
            return Objects.equals(this.keyId, configKey.keyId);
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + (this.keyId != null ? this.keyId.hashCode() : 0);
            return result;
        }
    }
}

