/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.reader;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.reader.password.KeyResourcePasswordLookup;
import be.atbash.util.exception.AtbashUnexpectedException;
import be.atbash.util.resource.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class KeyReaderKeyStore {
    public List<AtbashKey> readResource(String path, KeyResourcePasswordLookup passwordLookup) {
        KeyStore keyStore;
        ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        try (InputStream inputStream = ResourceUtil.getInstance().getStream(path);){
            keyStore.load(inputStream, passwordLookup.getResourcePassword(path));
            Enumeration<String> keyAliases = keyStore.aliases();
            while (keyAliases.hasMoreElements()) {
                String alias = keyAliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                char[] password = passwordLookup.getKeyPassword(path, alias);
                result.addAll(this.readKeysFromKeyEntry(keyStore, alias, password));
            }
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return result;
    }

    private List<AtbashKey> readKeysFromKeyEntry(KeyStore keyStore, String alias, char[] password) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
        PrivateKey key = (PrivateKey)keyStore.getKey(alias, password);
        result.add(new AtbashKey(alias, key));
        Certificate cert = keyStore.getCertificate(alias);
        PublicKey pkey = cert.getPublicKey();
        result.add(new AtbashKey(alias, pkey));
        return result;
    }
}

