/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.reader;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.reader.InvalidJWKSetFormatException;
import be.atbash.ee.security.octopus.keys.reader.KeyReaderJWK;
import be.atbash.ee.security.octopus.keys.reader.KeyResourceNotFoundException;
import be.atbash.ee.security.octopus.keys.reader.password.KeyResourcePasswordLookup;
import be.atbash.json.JSONArray;
import be.atbash.json.JSONObject;
import be.atbash.json.JSONValue;
import be.atbash.util.exception.AtbashUnexpectedException;
import be.atbash.util.resource.ResourceUtil;
import com.nimbusds.jose.JOSEException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;

public class KeyReaderJWKSet
extends KeyReaderJWK {
    @Override
    public List<AtbashKey> readResource(String path, KeyResourcePasswordLookup passwordLookup) {
        InputStream inputStream;
        try {
            inputStream = ResourceUtil.getInstance().getStream(path);
            if (inputStream == null) {
                throw new KeyResourceNotFoundException(path);
            }
        }
        catch (IOException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        String fileContent = new Scanner(inputStream).useDelimiter("\\Z").next();
        try {
            inputStream.close();
        }
        catch (IOException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return this.parseContent(path, passwordLookup, fileContent);
    }

    public List<AtbashKey> parseContent(String path, KeyResourcePasswordLookup passwordLookup, String fileContent) {
        ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
        JSONObject jsonObject = (JSONObject)JSONValue.parse((String)fileContent);
        JSONArray keys = (JSONArray)jsonObject.get((Object)"keys");
        try {
            HashSet<String> kids = new HashSet<String>();
            for (Object key : keys) {
                if (!(key instanceof JSONObject)) {
                    throw new InvalidJWKSetFormatException("The \"keys\" JSON array must contain JSON objects only");
                }
                JSONObject jwkJson = (JSONObject)key;
                String kid = jwkJson.getAsString("kid");
                if (kids.contains(kid)) {
                    throw new InvalidJWKSetFormatException(String.format("The kid '%s' was found multiple times in the resource '%s'", kid, path));
                }
                kids.add(kid);
                result.addAll(this.parse(jwkJson, path, passwordLookup));
            }
        }
        catch (JOSEException | ParseException e) {
            throw new AtbashUnexpectedException(e);
        }
        return result;
    }
}

