/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.reader;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.reader.KeyResourceNotFoundException;
import be.atbash.ee.security.octopus.keys.reader.password.KeyResourcePasswordLookup;
import be.atbash.ee.security.octopus.util.EncryptionHelper;
import be.atbash.json.JSONObject;
import be.atbash.json.JSONValue;
import be.atbash.util.exception.AtbashUnexpectedException;
import be.atbash.util.resource.ResourceUtil;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.crypto.bc.BouncyCastleProviderSingleton;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.RSAKey;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class KeyReaderJWK {
    public List<AtbashKey> readResource(String path, KeyResourcePasswordLookup passwordLookup) {
        List<AtbashKey> result;
        InputStream inputStream = null;
        try {
            inputStream = ResourceUtil.getInstance().getStream(path);
            if (inputStream == null) {
                throw new KeyResourceNotFoundException(path);
            }
            String fileContent = new Scanner(inputStream).useDelimiter("\\Z").next();
            JSONObject jsonObject = (JSONObject)JSONValue.parse((String)fileContent);
            result = this.parse(jsonObject, path, passwordLookup);
        }
        catch (JOSEException | IOException | ParseException e) {
            throw new AtbashUnexpectedException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new AtbashUnexpectedException((Throwable)e);
                }
            }
        }
        return result;
    }

    protected List<AtbashKey> parse(JSONObject jsonObject, String path, KeyResourcePasswordLookup passwordLookup) throws ParseException, JOSEException {
        JWK jwk;
        if (jsonObject.get((Object)"enc") == null) {
            jwk = JWK.parse((String)jsonObject.toJSONString());
        } else {
            char[] password = passwordLookup.getKeyPassword(path, jsonObject.getAsString("kid"));
            String decoded = EncryptionHelper.decode(jsonObject.getAsString("enc"), password);
            JSONObject decodedJSON = (JSONObject)JSONValue.parse((String)decoded);
            decodedJSON.merge((Object)jsonObject);
            jwk = JWK.parse((String)decodedJSON.toJSONString());
        }
        return this.processJWK(jwk);
    }

    private List<AtbashKey> processJWK(JWK jwk) throws JOSEException {
        PublicKey publicKey;
        PrivateKey privateKey;
        ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
        if (jwk instanceof AsymmetricJWK) {
            privateKey = jwk instanceof ECKey ? ((ECKey)jwk).toECPrivateKey((Provider)BouncyCastleProviderSingleton.getInstance()) : ((AsymmetricJWK)jwk).toPrivateKey();
            if (privateKey != null) {
                result.add(new AtbashKey(jwk.getKeyID(), privateKey));
            }
            if ((publicKey = ((AsymmetricJWK)jwk).toPublicKey()) != null) {
                result.add(new AtbashKey(jwk.getKeyID(), publicKey));
            }
        }
        if (result.isEmpty() && jwk instanceof RSAKey) {
            privateKey = ((RSAKey)jwk).toPrivateKey();
            if (privateKey != null) {
                result.add(new AtbashKey(jwk.getKeyID(), privateKey));
            }
            if ((publicKey = ((RSAKey)jwk).toPublicKey()) != null) {
                result.add(new AtbashKey(jwk.getKeyID(), publicKey));
            }
        }
        return result;
    }
}

