/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.reader;

import be.atbash.ee.security.octopus.config.JwtSupportConfiguration;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.reader.KeyReaderJWK;
import be.atbash.ee.security.octopus.keys.reader.KeyReaderJWKSet;
import be.atbash.ee.security.octopus.keys.reader.KeyReaderKeyStore;
import be.atbash.ee.security.octopus.keys.reader.KeyReaderPEM;
import be.atbash.ee.security.octopus.keys.reader.KeyResourceType;
import be.atbash.ee.security.octopus.keys.reader.KeyResourceTypeProvider;
import be.atbash.ee.security.octopus.keys.reader.UnknownKeyResourceTypeException;
import be.atbash.ee.security.octopus.keys.reader.password.KeyResourcePasswordLookup;
import be.atbash.util.CDIUtils;
import be.atbash.util.PublicAPI;
import java.lang.annotation.Annotation;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@PublicAPI
@ApplicationScoped
public class KeyReader {
    @Inject
    private JwtSupportConfiguration jwtSupportConfiguration;
    private KeyResourceTypeProvider keyResourceTypeProvider;
    private KeyReaderKeyStore keyReaderKeyStore = new KeyReaderKeyStore();
    private KeyReaderPEM keyReaderPEM = new KeyReaderPEM();
    private KeyReaderJWK keyReaderJWK = new KeyReaderJWK();
    private KeyReaderJWKSet keyReaderJWKSet = new KeyReaderJWKSet();

    @PostConstruct
    public void init() {
        this.keyResourceTypeProvider = (KeyResourceTypeProvider)CDIUtils.retrieveOptionalInstance(KeyResourceTypeProvider.class, (Annotation[])new Annotation[0]);
        if (this.keyResourceTypeProvider == null) {
            this.keyResourceTypeProvider = this.jwtSupportConfiguration.getKeyResourceTypeProvider();
        }
    }

    public List<AtbashKey> readKeyResource(String path, KeyResourcePasswordLookup passwordLookup) {
        List<AtbashKey> result;
        this.checkDependencies();
        KeyResourceType keyResourceType = this.keyResourceTypeProvider.determineKeyResourceType(path);
        if (keyResourceType == null) {
            throw new UnknownKeyResourceTypeException(path);
        }
        switch (keyResourceType) {
            case JWK: {
                result = this.keyReaderJWK.readResource(path, passwordLookup);
                break;
            }
            case JWKSET: {
                result = this.keyReaderJWKSet.readResource(path, passwordLookup);
                break;
            }
            case PEM: {
                result = this.keyReaderPEM.readResource(path, passwordLookup);
                break;
            }
            case KEYSTORE: {
                result = this.keyReaderKeyStore.readResource(path, passwordLookup);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown KeyResourceType %s", new Object[]{keyResourceType}));
            }
        }
        return result;
    }

    private void checkDependencies() {
        if (this.keyResourceTypeProvider == null) {
            this.jwtSupportConfiguration = JwtSupportConfiguration.getInstance();
            this.keyResourceTypeProvider = this.jwtSupportConfiguration.getKeyResourceTypeProvider();
        }
    }
}

