/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.reader;

import be.atbash.ee.security.octopus.config.JwtSupportConfiguration;
import be.atbash.ee.security.octopus.keys.reader.KeyResourceTypeProvider;
import be.atbash.util.CDIUtils;
import be.atbash.util.resource.ResourceScanner;
import be.atbash.util.resource.ResourceUtil;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.slf4j.Logger;

@ApplicationScoped
public class KeyFilesHelper {
    @Inject
    private Logger logger;
    @Inject
    private JwtSupportConfiguration jwtSupportConfiguration;
    @Inject
    private ResourceUtil resourceUtil;
    private KeyResourceTypeProvider keyResourceTypeProvider;
    private ResourceScanner scanner;

    @PostConstruct
    public void init() {
        this.keyResourceTypeProvider = (KeyResourceTypeProvider)CDIUtils.retrieveOptionalInstance(KeyResourceTypeProvider.class, (Annotation[])new Annotation[0]);
        if (this.keyResourceTypeProvider == null) {
            this.keyResourceTypeProvider = this.jwtSupportConfiguration.getKeyResourceTypeProvider();
        }
    }

    public List<String> determineKeyFiles(String keyConfigParameterValue) {
        File file;
        this.checkDependencies();
        ArrayList<String> result = new ArrayList<String>();
        if (this.resourceUtil.resourceExists(keyConfigParameterValue)) {
            if (keyConfigParameterValue.startsWith("classpath:")) {
                this.performScanning();
                String resourceName = keyConfigParameterValue.substring("classpath:".length());
                if (this.scanner.existsResource(resourceName)) {
                    result.add(keyConfigParameterValue);
                } else {
                    String pattern = resourceName + ".*";
                    Set resources = this.scanner.getResources(Pattern.compile(pattern));
                    for (String resource : resources) {
                        result.add("classpath:" + resource);
                    }
                }
            } else {
                result.add(keyConfigParameterValue);
            }
        } else if (keyConfigParameterValue.startsWith("file:") && (file = new File(keyConfigParameterValue.substring("file:".length()))).exists() && file.canRead() && file.isDirectory()) {
            for (File f : this.defineFiles(file)) {
                if (!f.isFile()) continue;
                result.add("file:" + f.getAbsoluteFile().toString());
            }
        }
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            String path = (String)iterator.next();
            if (this.keyResourceTypeProvider.determineKeyResourceType(path) != null) continue;
            iterator.remove();
            if (!this.logger.isWarnEnabled()) continue;
            this.logger.warn(String.format("(OCT-KEY-012) Unable to determine type of '%s'", path));
        }
        return result;
    }

    private List<File> defineFiles(File file) {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = file.listFiles();
        if (files == null) {
            return result;
        }
        for (File f : files) {
            if (f.isDirectory()) {
                result.addAll(this.defineFiles(f));
                continue;
            }
            result.add(f);
        }
        return result;
    }

    private void checkDependencies() {
        if (this.keyResourceTypeProvider == null) {
            this.jwtSupportConfiguration = JwtSupportConfiguration.getInstance();
            this.keyResourceTypeProvider = this.jwtSupportConfiguration.getKeyResourceTypeProvider();
        }
        if (this.resourceUtil == null) {
            this.resourceUtil = ResourceUtil.getInstance();
        }
    }

    private synchronized void performScanning() {
        if (this.scanner == null) {
            this.scanner = ResourceScanner.getInstance();
        }
    }
}

