/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.json;

import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.writer.KeyEncoderParameters;
import be.atbash.ee.security.octopus.keys.writer.KeyWriterFactory;
import be.atbash.json.JSONObject;
import be.atbash.json.writer.JSONWriter;
import be.atbash.util.base64.Base64Codec;
import java.io.IOException;

public class AtbashKeyWriter
implements JSONWriter<AtbashKey> {
    private KeyWriterFactory keyWriterFactory = new KeyWriterFactory();

    public AtbashKeyWriter() {
        this.keyWriterFactory.init();
    }

    public <E extends AtbashKey> void writeJSONString(E value, Appendable out) throws IOException {
        KeyEncoderParameters parameters = new KeyEncoderParameters();
        byte[] bytes = this.keyWriterFactory.writeKeyAsJWK(value, parameters);
        JSONObject jsonObject = new JSONObject();
        jsonObject.appendField("kid", (Object)value.getKeyId());
        jsonObject.appendField("key", (Object)Base64Codec.encodeToString((byte[])bytes, (boolean)true));
        out.append(jsonObject.toJSONString());
    }
}

