/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.json;

import be.atbash.ee.security.octopus.UnsupportedKeyType;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.json.JSONObject;
import be.atbash.json.JSONValue;
import be.atbash.json.writer.CustomBeanBuilderJSONEncoder;
import be.atbash.util.base64.Base64Codec;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.crypto.bc.BouncyCastleProviderSingleton;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.Provider;
import java.text.ParseException;

public class AtbashKeyCustomBeanJSONEncoder
extends CustomBeanBuilderJSONEncoder<AtbashKey, AtbashKey.AtbashKeyBuilder> {
    public AtbashKeyCustomBeanJSONEncoder() {
        super(AtbashKey.class, AtbashKey.AtbashKeyBuilder.class);
    }

    public void setBuilderValue(AtbashKey.AtbashKeyBuilder atbashKeyBuilder, String key, Object value) {
        if ("kid".equals(key)) {
            atbashKeyBuilder.withKeyId(value.toString());
        }
        if ("key".equals(key)) {
            JSONObject jsonObject = (JSONObject)JSONValue.parse((String)new String(Base64Codec.decode((String)value.toString())));
            try {
                JWK jwk = JWK.parse((String)jsonObject.toJSONString());
                boolean handled = false;
                if (KeyType.RSA.equals((Object)jwk.getKeyType())) {
                    RSAKey rsaKey = (RSAKey)jwk;
                    if (rsaKey.isPrivate()) {
                        atbashKeyBuilder.withKey(rsaKey.toPrivateKey());
                    } else {
                        atbashKeyBuilder.withKey(rsaKey.toPublicKey());
                    }
                    handled = true;
                }
                if (KeyType.EC.equals((Object)jwk.getKeyType())) {
                    ECKey ecKey = (ECKey)jwk;
                    if (ecKey.isPrivate()) {
                        atbashKeyBuilder.withKey(ecKey.toPrivateKey());
                    } else {
                        atbashKeyBuilder.withKey(ecKey.toECPublicKey((Provider)BouncyCastleProviderSingleton.getInstance()));
                    }
                    handled = true;
                }
                if (!handled) {
                    throw new UnsupportedKeyType(jwk.getKeyType(), "Key JSON deserialization ");
                }
            }
            catch (JOSEException | ParseException e) {
                throw new AtbashUnexpectedException(e);
            }
        }
    }

    public AtbashKey build(AtbashKey.AtbashKeyBuilder atbashKeyBuilder) {
        return atbashKeyBuilder.build();
    }
}

