/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.generator;

import be.atbash.ee.security.octopus.keys.generator.GenerationParameters;
import be.atbash.util.PublicAPI;
import com.nimbusds.jose.jwk.KeyType;

@PublicAPI
public class RSAGenerationParameters
extends GenerationParameters {
    private int keySize;

    private RSAGenerationParameters(RSAGenerationParametersBuilder builder) {
        super(builder, KeyType.RSA);
        this.keySize = builder.keySize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public static class RSAGenerationParametersBuilder
    extends GenerationParameters.GenerationParametersBuilders<RSAGenerationParametersBuilder> {
        private int keySize;

        public RSAGenerationParameters build() {
            this.applyDefaults();
            return new RSAGenerationParameters(this);
        }

        public RSAGenerationParametersBuilder withKeySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        @Override
        protected void applyDefaults() {
            super.applyDefaults();
            if (this.keySize == 0) {
                this.keySize = 2048;
            }
        }
    }
}

