/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.generator;

import be.atbash.ee.security.octopus.keys.generator.GenerationParameters;
import be.atbash.util.PublicAPI;
import com.nimbusds.jose.jwk.KeyType;

@PublicAPI
public class OCTGenerationParameters
extends GenerationParameters {
    private int keySize;

    private OCTGenerationParameters(OCTGenerationParametersBuilder builder) {
        super(builder, KeyType.OCT);
        this.keySize = builder.keySize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public static class OCTGenerationParametersBuilder
    extends GenerationParameters.GenerationParametersBuilders<OCTGenerationParametersBuilder> {
        private int keySize;

        public OCTGenerationParameters build() {
            this.applyDefaults();
            return new OCTGenerationParameters(this);
        }

        public OCTGenerationParametersBuilder withKeySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        @Override
        protected void applyDefaults() {
            super.applyDefaults();
            if (this.keySize == 0) {
                this.keySize = 256;
            }
        }
    }
}

