/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.generator;

import be.atbash.ee.security.octopus.UnsupportedKeyType;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.generator.DHGenerationParameters;
import be.atbash.ee.security.octopus.keys.generator.ECGenerationParameters;
import be.atbash.ee.security.octopus.keys.generator.GenerationParameters;
import be.atbash.ee.security.octopus.keys.generator.OCTGenerationParameters;
import be.atbash.ee.security.octopus.keys.generator.RSAGenerationParameters;
import be.atbash.util.PublicAPI;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.jwk.KeyType;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.SecretKeySpec;
import javax.enterprise.context.ApplicationScoped;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

@PublicAPI
@ApplicationScoped
public class KeyGenerator {
    private boolean initialized = false;

    @PostConstruct
    public void init() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.initialized = true;
    }

    private void doInitialize() {
        if (!this.initialized) {
            this.init();
        }
    }

    public List<AtbashKey> generateKeys(GenerationParameters parameters) {
        this.doInitialize();
        List<AtbashKey> result = null;
        if (KeyType.RSA.equals((Object)parameters.getKeyType())) {
            result = this.generateRSAKeys((RSAGenerationParameters)parameters);
        }
        if (KeyType.EC.equals((Object)parameters.getKeyType())) {
            result = this.generateECKeys((ECGenerationParameters)parameters);
        }
        if (KeyType.OCT.equals((Object)parameters.getKeyType())) {
            result = this.generateOctKey((OCTGenerationParameters)parameters);
        }
        if (DHGenerationParameters.DH.equals((Object)parameters.getKeyType())) {
            result = this.generateDHKeys((DHGenerationParameters)parameters);
        }
        if (result == null) {
            throw new UnsupportedKeyType(parameters.getKeyType(), "Key generation");
        }
        return result;
    }

    private List<AtbashKey> generateRSAKeys(RSAGenerationParameters generationParameters) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
            generator.initialize(generationParameters.getKeySize(), new SecureRandom());
            KeyPair kp = generator.generateKeyPair();
            RSAPublicKey pub = (RSAPublicKey)kp.getPublic();
            RSAPrivateKey priv = (RSAPrivateKey)kp.getPrivate();
            ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
            result.add(new AtbashKey(generationParameters.getKid(), pub));
            result.add(new AtbashKey(generationParameters.getKid(), priv));
            return result;
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }

    private List<AtbashKey> generateDHKeys(DHGenerationParameters generationParameters) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("DH");
            if (generationParameters.getParameterSpec() != null) {
                generator.initialize(generationParameters.getParameterSpec());
            } else {
                generator.initialize(generationParameters.getKeySize(), new SecureRandom());
            }
            KeyPair kp = generator.generateKeyPair();
            DHPublicKey pub = (DHPublicKey)kp.getPublic();
            DHPrivateKey priv = (DHPrivateKey)kp.getPrivate();
            ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
            result.add(new AtbashKey(generationParameters.getKid(), pub));
            result.add(new AtbashKey(generationParameters.getKid(), priv));
            return result;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }

    private List<AtbashKey> generateECKeys(ECGenerationParameters generationParameters) {
        try {
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)generationParameters.getCurveName());
            KeyPairGenerator g = KeyPairGenerator.getInstance("ECDSA", "BC");
            g.initialize((AlgorithmParameterSpec)ecSpec, new SecureRandom());
            KeyPair kp = g.generateKeyPair();
            ECPublicKey pub = (ECPublicKey)kp.getPublic();
            ECPrivateKey priv = (ECPrivateKey)kp.getPrivate();
            ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
            result.add(new AtbashKey(generationParameters.getKid(), pub));
            result.add(new AtbashKey(generationParameters.getKid(), priv));
            return result;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
    }

    private List<AtbashKey> generateOctKey(OCTGenerationParameters generationParameters) {
        byte[] bytes = new byte[generationParameters.getKeySize() / 8];
        new SecureRandom().nextBytes(bytes);
        SecretKeySpec secretKey = new SecretKeySpec(bytes, "AES");
        ArrayList<AtbashKey> result = new ArrayList<AtbashKey>();
        result.add(new AtbashKey(generationParameters.getKid(), secretKey));
        return result;
    }
}

