/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.generator;

import be.atbash.ee.security.octopus.keys.generator.KeyGenerationParameterException;
import be.atbash.util.PublicAPI;
import be.atbash.util.StringUtils;
import com.nimbusds.jose.jwk.KeyType;

@PublicAPI
public class GenerationParameters {
    private String kid;
    private KeyType keyType;

    GenerationParameters(GenerationParametersBuilders builder, KeyType keyType) {
        this.keyType = keyType;
        if (StringUtils.isEmpty((String)builder.kid)) {
            throw new KeyGenerationParameterException("Key id is required");
        }
        this.kid = builder.kid;
    }

    public String getKid() {
        return this.kid;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    static class GenerationParametersBuilders<T extends GenerationParametersBuilders<T>> {
        private String kid;

        GenerationParametersBuilders() {
        }

        public T withKeyId(String kid) {
            this.kid = kid;
            return (T)this;
        }

        protected void applyDefaults() {
        }
    }
}

