/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.generator;

import be.atbash.ee.security.octopus.keys.generator.GenerationParameters;
import be.atbash.ee.security.octopus.keys.generator.KeyGenerationParameterException;
import be.atbash.util.PublicAPI;
import be.atbash.util.StringUtils;
import com.nimbusds.jose.jwk.KeyType;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;

@PublicAPI
public class ECGenerationParameters
extends GenerationParameters {
    private String curveName;

    private ECGenerationParameters(ECGenerationParametersBuilder builder) {
        super(builder, KeyType.EC);
        if (StringUtils.isEmpty((String)builder.curveName)) {
            throw new KeyGenerationParameterException("EC Curve name is required");
        }
        this.curveName = builder.curveName;
    }

    public String getCurveName() {
        return this.curveName;
    }

    public static class ECGenerationParametersBuilder
    extends GenerationParameters.GenerationParametersBuilders<ECGenerationParametersBuilder> {
        private String curveName;

        public ECGenerationParameters build() {
            this.applyDefaults();
            return new ECGenerationParameters(this);
        }

        public ECGenerationParametersBuilder withCurveName(String curveName) {
            ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)curveName);
            if (ecSpec == null) {
                throw new KeyGenerationParameterException(String.format("EC Curve name '%s' unknown", curveName));
            }
            this.curveName = curveName;
            return this;
        }
    }
}

