/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys.generator;

import be.atbash.ee.security.octopus.keys.generator.GenerationParameters;
import be.atbash.util.PublicAPI;
import com.nimbusds.jose.Requirement;
import com.nimbusds.jose.jwk.KeyType;
import javax.crypto.spec.DHParameterSpec;

@PublicAPI
public class DHGenerationParameters
extends GenerationParameters {
    public static final KeyType DH = new KeyType("DH", Requirement.OPTIONAL);
    private int keySize;
    private DHParameterSpec parameterSpec;

    private DHGenerationParameters(DHGenerationParametersBuilder builder) {
        super(builder, DH);
        this.keySize = builder.keySize;
        this.parameterSpec = builder.parameterSpec;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public DHParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    public static class DHGenerationParametersBuilder
    extends GenerationParameters.GenerationParametersBuilders<DHGenerationParametersBuilder> {
        private int keySize;
        private DHParameterSpec parameterSpec;

        public DHGenerationParameters build() {
            this.applyDefaults();
            return new DHGenerationParameters(this);
        }

        public DHGenerationParametersBuilder withKeySize(int keySize) {
            this.keySize = keySize;
            return this;
        }

        public DHGenerationParametersBuilder withDHParamaterSpec(DHParameterSpec dhParamaterSpec) {
            this.parameterSpec = dhParamaterSpec;
            return this;
        }

        @Override
        protected void applyDefaults() {
            super.applyDefaults();
            if (this.keySize == 0 && this.parameterSpec == null) {
                this.keySize = 2048;
            }
        }
    }
}

