/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys;

import be.atbash.config.exception.ConfigurationException;
import be.atbash.ee.security.octopus.config.JwtSupportConfiguration;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.ee.security.octopus.keys.KeyManager;
import be.atbash.ee.security.octopus.keys.reader.KeyFilesHelper;
import be.atbash.ee.security.octopus.keys.reader.KeyReader;
import be.atbash.ee.security.octopus.keys.reader.KeyReaderJWKSet;
import be.atbash.ee.security.octopus.keys.reader.password.KeyResourcePasswordLookup;
import be.atbash.ee.security.octopus.keys.selector.SelectorCriteria;
import be.atbash.ee.security.octopus.keys.selector.filter.KeyFilter;
import be.atbash.util.StringUtils;
import be.atbash.util.exception.AtbashIllegalActionException;
import be.atbash.util.exception.AtbashUnexpectedException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import javax.enterprise.inject.Vetoed;

@Vetoed
public class LocalKeyManager
implements KeyManager {
    private static final Object LOCK = new Object();
    private JwtSupportConfiguration configuration;
    private KeyReader keyReader;
    private KeyFilesHelper keyFilesHelper;
    private KeyResourcePasswordLookup passwordLookup;
    private KeyReaderJWKSet keyReaderJWKSet;
    private List<AtbashKey> keys = new ArrayList<AtbashKey>();

    @Override
    public List<AtbashKey> retrieveKeys(SelectorCriteria selectorCriteria) {
        if (selectorCriteria == null) {
            throw new AtbashIllegalActionException("Parameter selectorCriteria can't be null");
        }
        List<KeyFilter> filters = selectorCriteria.asKeyFilters();
        if (selectorCriteria.getJku() == null) {
            this.checkKeyLoading();
        } else {
            this.checkDependencies();
        }
        List<AtbashKey> result = this.filterKeys(filters);
        if (result.isEmpty() && selectorCriteria.getJku() != null) {
            this.loadRemoteKeys(selectorCriteria.getJku());
            result = this.filterKeys(filters);
        }
        return result;
    }

    private void loadRemoteKeys(URI jkuURL) {
        String fileContent;
        try {
            URL url = jkuURL.toURL();
            URLConnection uc = url.openConnection();
            InputStream inputStream = uc.getInputStream();
            fileContent = new Scanner(inputStream).useDelimiter("\\Z").next();
            inputStream.close();
        }
        catch (IOException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        List<AtbashKey> atbashKeys = this.keyReaderJWKSet.parseContent(null, this.passwordLookup, fileContent);
        this.keys.addAll(atbashKeys);
    }

    private List<AtbashKey> filterKeys(List<KeyFilter> filters) {
        List<AtbashKey> result = new ArrayList<AtbashKey>(this.keys);
        for (KeyFilter filter : filters) {
            result = filter.filter(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkKeyLoading() {
        if (this.keys.isEmpty()) {
            Object object = LOCK;
            synchronized (object) {
                if (this.keys.isEmpty()) {
                    this.checkDependencies();
                    String keysLocation = this.configuration.getKeysLocation();
                    if (StringUtils.isEmpty((String)keysLocation)) {
                        throw new ConfigurationException("Parameter keys.location is required to have a value");
                    }
                    List<String> keyFiles = this.keyFilesHelper.determineKeyFiles(keysLocation);
                    for (String keyFile : keyFiles) {
                        this.keys.addAll(this.keyReader.readKeyResource(keyFile, this.passwordLookup));
                    }
                }
            }
        }
    }

    private void checkDependencies() {
        if (this.configuration == null) {
            this.configuration = new JwtSupportConfiguration();
            this.keyReader = new KeyReader();
            this.keyFilesHelper = new KeyFilesHelper();
            this.keyReaderJWKSet = new KeyReaderJWKSet();
            this.passwordLookup = this.configuration.getPasswordLookup();
        }
    }

    public String toString() {
        return "class " + LocalKeyManager.class.getName();
    }
}

