/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.keys;

import be.atbash.ee.security.octopus.keys.json.AtbashKeyCustomBeanJSONEncoder;
import be.atbash.ee.security.octopus.keys.json.AtbashKeyWriter;
import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import be.atbash.ee.security.octopus.keys.selector.SecretKeyType;
import be.atbash.json.parser.MappedBy;
import be.atbash.util.PublicAPI;
import java.security.Key;

@MappedBy(writer=AtbashKeyWriter.class, beanEncoder=AtbashKeyCustomBeanJSONEncoder.class)
@PublicAPI
public class AtbashKey {
    private String keyId;
    private SecretKeyType secretKeyType;
    private Key key;

    public AtbashKey(String path, Key key) {
        if (key == null) {
            throw new IllegalArgumentException("Parameter key cannot be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Parameter path cannot be null");
        }
        this.keyId = this.defineKeyId(path);
        this.key = key;
        this.secretKeyType = SecretKeyType.fromKey(key);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public SecretKeyType getSecretKeyType() {
        return this.secretKeyType;
    }

    public Key getKey() {
        return this.key;
    }

    private String defineKeyId(String value) {
        String result = value;
        if (value.startsWith("classpath:")) {
            int prefixStart = result.lastIndexOf(46);
            if (prefixStart != -1) {
                result = result.substring(0, prefixStart);
            }
            result = result.substring("classpath:".length());
        }
        return result;
    }

    public boolean isMatch(String keyId, AsymmetricPart asymmetricPart) {
        return this.keyId.equals(keyId) && this.secretKeyType.getAsymmetricPart() == asymmetricPart;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AtbashKey atbashKey = (AtbashKey)o;
        if (!this.keyId.equals(atbashKey.keyId)) {
            return false;
        }
        return this.secretKeyType.equals(atbashKey.secretKeyType);
    }

    public int hashCode() {
        int result = this.keyId.hashCode();
        result = 31 * result + this.secretKeyType.hashCode();
        return result;
    }

    public static class AtbashKeyBuilder {
        private String keyId;
        private Key key;

        public AtbashKeyBuilder withKeyId(String keyId) {
            this.keyId = keyId;
            return this;
        }

        public AtbashKeyBuilder withKey(Key key) {
            this.key = key;
            return this;
        }

        public AtbashKey build() {
            return new AtbashKey(this.keyId, this.key);
        }
    }
}

