/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.parameter;

import be.atbash.ee.security.octopus.jwt.parameter.JWTParameterHeaderDefaultProvider;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParameterHeaderDefaultProviderServiceLoader;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParameters;
import java.util.List;
import java.util.Map;

abstract class JWTParametersHeader
implements JWTParameters {
    private Map<String, Object> headerValues;

    JWTParametersHeader(Map<String, Object> headerValues) {
        this.headerValues = headerValues;
        this.addDefaults();
    }

    private void addDefaults() {
        List<JWTParameterHeaderDefaultProvider> defaultProviders = JWTParameterHeaderDefaultProviderServiceLoader.getDefaultProviders();
        for (JWTParameterHeaderDefaultProvider defaultProvider : defaultProviders) {
            Map<String, Object> values = defaultProvider.defaultHeaderValues();
            this.applyDefaults(values);
        }
    }

    private void applyDefaults(Map<String, Object> values) {
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            if (this.headerValues.containsKey(entry.getKey())) continue;
            this.headerValues.put(entry.getKey(), entry.getValue());
        }
    }

    public Map<String, Object> getHeaderValues() {
        return this.headerValues;
    }
}

