/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.parameter;

import be.atbash.ee.security.octopus.jwt.JWTEncoding;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParameters;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersEncryption;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersNone;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersSigning;
import be.atbash.ee.security.octopus.keys.AtbashKey;
import be.atbash.util.PublicAPI;
import be.atbash.util.exception.AtbashIllegalActionException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI
public final class JWTParametersBuilder {
    private Logger logger = LoggerFactory.getLogger(JWTParametersBuilder.class);
    private JWTEncoding encoding;
    private Map<String, Object> headerValues;
    private AtbashKey secretKeySigning;
    private AtbashKey secretKeyEncryption;
    private JWTParametersSigning parametersSigning;

    private JWTParametersBuilder(JWTEncoding encoding) {
        this.encoding = encoding;
        this.headerValues = new HashMap<String, Object>();
    }

    public JWTParametersBuilder withHeader(String key, String value) {
        if (this.encoding == JWTEncoding.NONE) {
            this.logger.warn("Header values are not supported with JWTEncoding.NONE");
        }
        this.headerValues.put(key, value);
        return this;
    }

    public JWTParametersBuilder withJSONKeyURL(String url) {
        return this.withHeader("jku", url);
    }

    public JWTParametersBuilder withSecretKeyForSigning(AtbashKey key) {
        if (this.encoding == JWTEncoding.NONE) {
            this.logger.warn("SecretKey value is not supported with JWTEncoding.NONE");
        }
        this.secretKeySigning = key;
        return this;
    }

    public JWTParametersBuilder withSecretKeyForEncryption(AtbashKey key) {
        if (this.encoding != JWTEncoding.JWE) {
            this.logger.warn("SecretKey value for encryption only needed for JWTEncoding.JWE");
        }
        this.secretKeyEncryption = key;
        return this;
    }

    public JWTParametersBuilder withSigningParameters(JWTParametersSigning parametersSigning) {
        this.parametersSigning = parametersSigning;
        return this;
    }

    public JWTParameters build() {
        JWTParameters result;
        this.validateParameters();
        switch (this.encoding) {
            case NONE: {
                result = new JWTParametersNone();
                break;
            }
            case JWS: {
                result = new JWTParametersSigning(this.headerValues, this.secretKeySigning);
                break;
            }
            case JWE: {
                if (this.parametersSigning == null) {
                    this.parametersSigning = new JWTParametersSigning(this.headerValues, this.secretKeySigning);
                }
                result = new JWTParametersEncryption(this.parametersSigning, this.headerValues, this.secretKeyEncryption);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported value for JWTEncoding : %s", new Object[]{this.encoding}));
            }
        }
        return result;
    }

    private void validateParameters() {
        switch (this.encoding) {
            case NONE: {
                break;
            }
            case JWS: {
                this.validateJWSParameters();
                break;
            }
            case JWE: {
                this.validateJWEParameters();
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported value for JWTEncoding : %s", new Object[]{this.encoding}));
            }
        }
    }

    private void validateJWEParameters() {
        if (this.secretKeyEncryption == null) {
            throw new AtbashIllegalActionException("(OCT-DEV-106) JWE encoding requires a JWK secret for the encryption");
        }
    }

    private void validateJWSParameters() {
        if (this.secretKeySigning == null) {
            throw new AtbashIllegalActionException("(OCT-DEV-105) JWS encoding requires a JWK secret for the signing");
        }
    }

    public static JWTParametersBuilder newBuilderFor(JWTEncoding encoding) {
        return new JWTParametersBuilder(encoding);
    }
}

