/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.encoder;

import be.atbash.ee.security.octopus.UnsupportedKeyType;
import be.atbash.ee.security.octopus.config.JwtSupportConfiguration;
import be.atbash.ee.security.octopus.exception.UnsupportedECCurveException;
import be.atbash.ee.security.octopus.jwt.encoder.HMACAlgorithmFactory;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersSigning;
import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.KeyType;
import java.security.PrivateKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.ECParameterSpec;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@ApplicationScoped
public class JWTSignerFactory {
    @Inject
    private HMACAlgorithmFactory hmacAlgorithmFactory;
    @Inject
    private JwtSupportConfiguration jwtSupportConfiguration;

    public JWSSigner createSigner(JWTParametersSigning parametersSigning) {
        MACSigner result = null;
        if (KeyType.OCT.equals((Object)parametersSigning.getKeyType())) {
            try {
                result = new MACSigner(parametersSigning.getKey().getEncoded());
            }
            catch (KeyLengthException e) {
                throw new AtbashUnexpectedException((Throwable)e);
            }
        }
        if (KeyType.RSA.equals((Object)parametersSigning.getKeyType())) {
            if (parametersSigning.getKey() instanceof PrivateKey) {
                result = new RSASSASigner((PrivateKey)parametersSigning.getKey());
            } else {
                throw new UnsupportedKeyType(AsymmetricPart.PRIVATE, "JWS Signing");
            }
        }
        if (KeyType.EC.equals((Object)parametersSigning.getKeyType())) {
            if (parametersSigning.getKey() instanceof ECPrivateKey) {
                try {
                    result = new ECDSASigner((ECPrivateKey)parametersSigning.getKey());
                }
                catch (JOSEException e) {
                    throw new UnsupportedECCurveException(e.getMessage());
                }
            } else {
                throw new UnsupportedKeyType(AsymmetricPart.PRIVATE, "JWS Signing");
            }
        }
        if (result == null) {
            throw new UnsupportedKeyType(parametersSigning.getKeyType(), "JWT Signing");
        }
        return result;
    }

    public JWSAlgorithm defineJWSAlgorithm(JWTParametersSigning parametersSigning) {
        this.checkDependencies();
        JWSAlgorithm result = null;
        if (KeyType.OCT.equals((Object)parametersSigning.getKeyType())) {
            result = this.hmacAlgorithmFactory.determineOptimalAlgorithm(parametersSigning.getKey().getEncoded());
        }
        if (KeyType.RSA.equals((Object)parametersSigning.getKeyType())) {
            result = this.jwtSupportConfiguration.getJWSAlgorithmForRSA();
        }
        if (KeyType.EC.equals((Object)parametersSigning.getKeyType())) {
            try {
                result = this.resolveAlgorithm((ECKey)((Object)parametersSigning.getKey()));
            }
            catch (JOSEException e) {
                throw new UnsupportedECCurveException(e.getMessage());
            }
        }
        if (result == null) {
            throw new UnsupportedKeyType(parametersSigning.getKeyType(), "JWT Signing");
        }
        return result;
    }

    private JWSAlgorithm resolveAlgorithm(ECKey ecKey) throws JOSEException {
        ECParameterSpec ecParameterSpec = ecKey.getParams();
        return this.resolveAlgorithm(Curve.forECParameterSpec((ECParameterSpec)ecParameterSpec));
    }

    private JWSAlgorithm resolveAlgorithm(Curve curve) throws JOSEException {
        if (curve == null) {
            throw new JOSEException("The EC key curve is not supported, must be P-256, P-384 or P-521");
        }
        if (Curve.P_256.equals((Object)curve)) {
            return JWSAlgorithm.ES256;
        }
        if (Curve.P_256K.equals((Object)curve)) {
            return JWSAlgorithm.ES256K;
        }
        if (Curve.P_384.equals((Object)curve)) {
            return JWSAlgorithm.ES384;
        }
        if (Curve.P_521.equals((Object)curve)) {
            return JWSAlgorithm.ES512;
        }
        throw new JOSEException("Unexpected curve: " + curve);
    }

    private void checkDependencies() {
        if (this.hmacAlgorithmFactory == null) {
            this.hmacAlgorithmFactory = new HMACAlgorithmFactory();
        }
        if (this.jwtSupportConfiguration == null) {
            this.jwtSupportConfiguration = JwtSupportConfiguration.getInstance();
        }
    }
}

