/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.encoder;

import be.atbash.ee.security.octopus.UnsupportedKeyType;
import be.atbash.ee.security.octopus.jwt.encoder.JWEEncryptionFactory;
import be.atbash.ee.security.octopus.jwt.encoder.JWTSignerFactory;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParameters;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersEncryption;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersSigning;
import be.atbash.json.JSONValue;
import be.atbash.util.PublicAPI;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.jwk.KeyType;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

@PublicAPI
@ApplicationScoped
public class JWTEncoder {
    @Inject
    private JWTSignerFactory signerFactory;
    @Inject
    private JWEEncryptionFactory encryptionFactory;

    public String encode(Object data, JWTParameters parameters) {
        String result;
        this.checkDependencies();
        try {
            switch (parameters.getEncoding()) {
                case NONE: {
                    result = this.createJSONString(data);
                    break;
                }
                case JWS: {
                    result = this.createSignedJWT(data, (JWTParametersSigning)parameters);
                    break;
                }
                case JWE: {
                    result = this.createEncryptedJWE(data, (JWTParametersEncryption)parameters);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("JWTEncoding not supported %s", new Object[]{parameters.getEncoding()}));
                }
            }
        }
        catch (JOSEException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return result;
    }

    private String createEncryptedJWE(Object data, JWTParametersEncryption parameters) throws JOSEException {
        JWEAlgorithm jweAlgorithm = null;
        if (parameters.getKeyType() == KeyType.RSA) {
            jweAlgorithm = JWEAlgorithm.RSA_OAEP_256;
        }
        if (parameters.getKeyType() == KeyType.EC) {
            jweAlgorithm = JWEAlgorithm.ECDH_ES_A256KW;
        }
        if (parameters.getKeyType() == KeyType.OCT) {
            jweAlgorithm = JWEAlgorithm.A256KW;
        }
        if (jweAlgorithm == null) {
            throw new UnsupportedKeyType(parameters.getKeyType(), "JWE creation");
        }
        JWEObject jweObject = new JWEObject(new JWEHeader.Builder(jweAlgorithm, EncryptionMethod.A256GCM).keyID(parameters.getKeyID()).customParams(parameters.getHeaderValues()).contentType("JWT").build(), new Payload(this.createSignedJWT(data, parameters.getParametersSigning())));
        jweObject.encrypt(this.encryptionFactory.createEncryptor(parameters));
        return jweObject.serialize();
    }

    private String createSignedJWT(Object data, JWTParametersSigning parameters) throws JOSEException {
        JWSObject jwsObject = this.createJWTObject(data, parameters);
        return jwsObject.serialize();
    }

    private JWSObject createJWTObject(Object data, JWTParametersSigning parameters) throws JOSEException {
        String payload = this.createJSONString(data);
        JWSHeader header = new JWSHeader.Builder(this.signerFactory.defineJWSAlgorithm(parameters)).type(JOSEObjectType.JWT).keyID(parameters.getKeyID()).customParams(parameters.getHeaderValues()).build();
        JWSObject jwsObject = new JWSObject(header, new Payload(payload));
        JWSSigner signer = this.signerFactory.createSigner(parameters);
        jwsObject.sign(signer);
        return jwsObject;
    }

    private String createJSONString(Object data) {
        return JSONValue.toJSONString((Object)data);
    }

    private void checkDependencies() {
        if (this.signerFactory == null) {
            this.signerFactory = new JWTSignerFactory();
        }
        if (this.encryptionFactory == null) {
            this.encryptionFactory = new JWEEncryptionFactory();
        }
    }
}

