/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.encoder;

import be.atbash.ee.security.octopus.UnsupportedKeyType;
import be.atbash.ee.security.octopus.exception.UnsupportedECCurveException;
import be.atbash.ee.security.octopus.exception.UnsupportedKeyLengthException;
import be.atbash.ee.security.octopus.jwt.parameter.JWTParametersEncryption;
import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.AESEncrypter;
import com.nimbusds.jose.crypto.ECDHEncrypter;
import com.nimbusds.jose.crypto.RSAEncrypter;
import com.nimbusds.jose.jwk.KeyType;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.SecretKey;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class JWEEncryptionFactory {
    private static final String JWE_CREATION = "JWE creation";

    public JWEEncrypter createEncryptor(JWTParametersEncryption parametersEncryption) {
        RSAEncrypter result = null;
        if (KeyType.RSA.equals((Object)parametersEncryption.getKeyType())) {
            if (parametersEncryption.getKey() instanceof RSAPublicKey) {
                result = new RSAEncrypter((RSAPublicKey)parametersEncryption.getKey());
            } else {
                throw new UnsupportedKeyType(AsymmetricPart.PUBLIC, JWE_CREATION);
            }
        }
        if (KeyType.EC.equals((Object)parametersEncryption.getKeyType())) {
            if (parametersEncryption.getKey() instanceof ECPublicKey) {
                try {
                    result = new ECDHEncrypter((ECPublicKey)parametersEncryption.getKey());
                }
                catch (JOSEException e) {
                    throw new UnsupportedECCurveException(e.getMessage());
                }
            } else {
                throw new UnsupportedKeyType(AsymmetricPart.PUBLIC, JWE_CREATION);
            }
        }
        if (KeyType.OCT.equals((Object)parametersEncryption.getKeyType())) {
            try {
                result = new AESEncrypter((SecretKey)parametersEncryption.getKey());
            }
            catch (KeyLengthException e) {
                throw new UnsupportedKeyLengthException("Unsupported Key length");
            }
        }
        if (result == null) {
            throw new UnsupportedKeyType(parametersEncryption.getKeyType(), JWE_CREATION);
        }
        return result;
    }
}

