/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwt.decoder;

import be.atbash.ee.security.octopus.jwt.InvalidJWTException;
import be.atbash.ee.security.octopus.jwt.JWTEncoding;
import be.atbash.ee.security.octopus.jwt.decoder.JWTData;
import be.atbash.ee.security.octopus.jwt.decoder.JWTVerifier;
import be.atbash.ee.security.octopus.jwt.decoder.MetaJWTData;
import be.atbash.ee.security.octopus.keys.selector.AsymmetricPart;
import be.atbash.ee.security.octopus.keys.selector.KeySelector;
import be.atbash.ee.security.octopus.keys.selector.SelectorCriteria;
import be.atbash.json.JSONValue;
import be.atbash.util.PublicAPI;
import be.atbash.util.StringUtils;
import be.atbash.util.exception.AtbashIllegalActionException;
import be.atbash.util.exception.AtbashUnexpectedException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import com.nimbusds.jose.proc.JWEDecrypterFactory;
import com.nimbusds.jose.proc.JWSVerifierFactory;
import com.nimbusds.jwt.SignedJWT;
import java.net.URI;
import java.text.ParseException;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicAPI
@ApplicationScoped
public class JWTDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeySelector.class);
    private JWSVerifierFactory jwsVerifierFactory = new DefaultJWSVerifierFactory();
    private JWEDecrypterFactory jweDecrypterFactory = new DefaultJWEDecrypterFactory();

    public <T> T decode(String data, Class<T> classType) {
        return this.decode(data, classType, null, null).getData();
    }

    public <T> JWTData<T> decode(String data, Class<T> classType, KeySelector keySelector, JWTVerifier verifier) {
        JWTData<T> result;
        JWTEncoding encoding = this.determineEncoding(data);
        if (encoding == null) {
            throw new IllegalArgumentException("Unable to determine the encoding of the data");
        }
        try {
            switch (encoding) {
                case NONE: {
                    result = this.readJSONString(data, classType);
                    break;
                }
                case JWS: {
                    if (keySelector == null) {
                        throw new AtbashIllegalActionException("(OCT-DEV-101) keySelector required for decoding a JWT encoded value");
                    }
                    result = this.readSignedJWT(data, keySelector, classType, verifier);
                    break;
                }
                case JWE: {
                    if (keySelector == null) {
                        throw new AtbashIllegalActionException("(OCT-DEV-101) keySelector required for decoding a JWE encoded value");
                    }
                    result = this.readEncryptedJWT(data, keySelector, classType, verifier);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("JWTEncoding not supported %s", new Object[]{encoding}));
                }
            }
        }
        catch (ParseException e) {
            throw new InvalidJWTException("Invalid JWT structure");
        }
        catch (JOSEException e) {
            throw new AtbashUnexpectedException((Throwable)e);
        }
        return result;
    }

    private <T> JWTData<T> readEncryptedJWT(String data, KeySelector keySelector, Class<T> classType, JWTVerifier verifier) throws ParseException, JOSEException {
        JWEAlgorithm algorithm;
        JWEObject jweObject = JWEObject.parse((String)data);
        String keyID = jweObject.getHeader().getKeyID();
        SelectorCriteria criteria = SelectorCriteria.newBuilder().withId(keyID).withAsymmetricPart(AsymmetricPart.PRIVATE).build();
        Object key = keySelector.selectSecretKey(criteria);
        if (key == null && (algorithm = jweObject.getHeader().getAlgorithm()).equals((Object)JWEAlgorithm.A256KW)) {
            criteria = SelectorCriteria.newBuilder().withId(keyID).build();
            key = keySelector.selectSecretKey(criteria);
        }
        if (key == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(String.format("(OCT-KEY-010) No or multiple keys found for criteria :%n %s", criteria.toString()));
            }
            throw new InvalidJWTException(String.format("No key found for %s", keyID));
        }
        JWEDecrypter decrypter = this.jweDecrypterFactory.createJWEDecrypter(jweObject.getHeader(), key);
        jweObject.decrypt(decrypter);
        return this.readSignedJWT(jweObject.getPayload().toString(), keySelector, classType, verifier);
    }

    private <T> JWTData<T> readSignedJWT(String data, KeySelector keySelector, Class<T> classType, JWTVerifier verifier) throws ParseException, JOSEException {
        SignedJWT signedJWT = SignedJWT.parse((String)data);
        String keyID = signedJWT.getHeader().getKeyID();
        URI jwkURI = signedJWT.getHeader().getJWKURL();
        SelectorCriteria criteria = SelectorCriteria.newBuilder().withId(keyID).withJKU(jwkURI).withAsymmetricPart(AsymmetricPart.PUBLIC).build();
        Object key = keySelector.selectSecretKey(criteria);
        if (key == null && signedJWT.getHeader().getAlgorithm() == JWSAlgorithm.HS256) {
            criteria = SelectorCriteria.newBuilder().withId(keyID).withJKU(jwkURI).build();
            key = keySelector.selectSecretKey(criteria);
        }
        if (key == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(String.format("(OCT-KEY-010) No or multiple keys found for criteria :%n %s", criteria.toString()));
            }
            throw new InvalidJWTException(String.format("No key found for keyId '%s'", keyID));
        }
        JWSVerifier jwsVerifier = this.jwsVerifierFactory.createJWSVerifier(signedJWT.getHeader(), key);
        if (!signedJWT.verify(jwsVerifier)) {
            throw new InvalidJWTException("JWT Signature verification failed");
        }
        if (verifier != null && !verifier.verify(signedJWT.getHeader(), signedJWT.getJWTClaimsSet())) {
            throw new InvalidJWTException("JWT verification failed");
        }
        MetaJWTData metaJWTData = new MetaJWTData(keyID, signedJWT.getHeader().getCustomParams());
        return this.readJSONString(signedJWT.getPayload().toString(), classType, metaJWTData);
    }

    private <T> JWTData<T> readJSONString(String data, Class<T> classType) {
        return this.readJSONString(data, classType, new MetaJWTData());
    }

    private <T> JWTData<T> readJSONString(String data, Class<T> classType, MetaJWTData metaJWTData) {
        return new JWTData<Object>(JSONValue.parse((String)data, classType), metaJWTData);
    }

    private JWTEncoding determineEncoding(String data) {
        JWTEncoding result = null;
        if (data.startsWith("{")) {
            result = JWTEncoding.NONE;
        }
        if (data.startsWith("ey")) {
            int occurrences = StringUtils.countOccurrences((String)data, (char)'.');
            if (occurrences == 2) {
                result = JWTEncoding.JWS;
            }
            if (occurrences == 4) {
                result = JWTEncoding.JWE;
            }
        }
        return result;
    }
}

