/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.jwk;

import be.atbash.ee.security.octopus.exception.MissingPasswordException;
import be.atbash.ee.security.octopus.util.EncryptionHelper;
import be.atbash.util.StringUtils;
import com.nimbusds.jose.jwk.JWK;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minidev.json.JSONObject;

public final class EncryptedJSONJWK {
    private static final List<String> GENERAL_NAMES = Arrays.asList("kty", "use", "key_ops", "alg", "kid", "crv");

    private EncryptedJSONJWK() {
    }

    public static String encryptedOutput(JWK jwk, char[] password) {
        if (StringUtils.isEmpty((char[])password)) {
            throw new MissingPasswordException(MissingPasswordException.ObjectType.ENCRYPTION, null);
        }
        JSONObject fullJWK = jwk.toJSONObject();
        JSONObject encryptedJWK = new JSONObject();
        JSONObject sensitiveProperties = new JSONObject();
        for (Map.Entry entry : fullJWK.entrySet()) {
            if (GENERAL_NAMES.contains(entry.getKey())) {
                encryptedJWK.appendField((String)entry.getKey(), entry.getValue());
                continue;
            }
            sensitiveProperties.appendField((String)entry.getKey(), entry.getValue());
        }
        String json = sensitiveProperties.toJSONString();
        encryptedJWK.appendField("enc", (Object)EncryptionHelper.encode(json, password));
        return encryptedJWK.toJSONString();
    }
}

