/*
 * Decompiled with CFR 0.152.
 */
package be.atbash.ee.security.octopus.exception;

import be.atbash.util.PublicAPI;
import be.atbash.util.exception.AtbashException;

@PublicAPI
public class MissingPasswordException
extends AtbashException {
    public MissingPasswordException(ObjectType objectType) {
        super(MissingPasswordException.defineMessage(objectType, null));
    }

    public MissingPasswordException(ObjectType objectType, String path) {
        super(MissingPasswordException.defineMessage(objectType, path));
    }

    private static String defineMessage(ObjectType objectType, String path) {
        if (objectType == ObjectType.STORE) {
            return String.format("Password required for opening key store '%s'", path);
        }
        if (objectType == ObjectType.ENCRYPTION) {
            return "Password required for encryption/decryption";
        }
        throw new UnsupportedOperationException(String.format("Unknown value for ObjectType %s", new Object[]{objectType}));
    }

    public static enum ObjectType {
        STORE,
        ENCRYPTION;

    }
}

